/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.util;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Cookie;

public class CookieParser {
    public static List<Cookie> parseCookies(String cookieHeader) {
        if (cookieHeader == null) {
            throw new IllegalArgumentException("Cookie value was null");
        }
        try {
            String[] parts;
            ArrayList<Cookie> cookies = new ArrayList<Cookie>();
            int version = 0;
            String domain = null;
            String path = null;
            String cookieName = null;
            String cookieValue = null;
            for (String part : parts = cookieHeader.split("[;,]")) {
                String value;
                String[] nv = part.split("=", 2);
                String name = nv.length > 0 ? nv[0].trim() : "";
                String string = value = nv.length > 1 ? nv[1].trim() : "";
                if (value.startsWith("\"") && value.endsWith("\"") && value.length() > 1) {
                    value = value.substring(1, value.length() - 1);
                }
                if (!name.startsWith("$")) {
                    if (cookieName != null) {
                        cookies.add(new Cookie(cookieName, cookieValue, path, domain, version));
                        domain = null;
                        path = null;
                        cookieValue = null;
                        cookieName = null;
                    }
                    cookieName = name;
                    cookieValue = value;
                    continue;
                }
                if (name.equalsIgnoreCase("$Version")) {
                    version = Integer.parseInt(value);
                    continue;
                }
                if (name.equalsIgnoreCase("$Path")) {
                    path = value;
                    continue;
                }
                if (!name.equalsIgnoreCase("$Domain")) continue;
                domain = value;
            }
            if (cookieName != null) {
                cookies.add(new Cookie(cookieName, cookieValue, path, domain, version));
            }
            return cookies;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to parse cookie: " + cookieHeader, ex);
        }
    }
}

