/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.jaxrs;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Priority;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.RxInvokerProvider;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.reactive.common.core.UnmanagedBeanFactory;
import org.jboss.resteasy.reactive.common.model.ResourceReader;
import org.jboss.resteasy.reactive.common.model.ResourceWriter;
import org.jboss.resteasy.reactive.common.util.MultivaluedTreeMap;
import org.jboss.resteasy.reactive.common.util.QuarkusMultivaluedHashMap;
import org.jboss.resteasy.reactive.common.util.types.Types;

public class ConfigurationImpl
implements Configuration {
    public static final List<MediaType> WILDCARD_LIST = Collections.singletonList(MediaType.WILDCARD_TYPE);
    public static final List<String> WILDCARD_STRING_LIST = Collections.singletonList("*/*");
    private final RuntimeType runtimeType;
    private final Map<String, Object> properties;
    private final Map<Class<?>, Object> allInstances;
    private final List<Feature> enabledFeatures;
    private final Map<Class<?>, Map<Class<?>, Integer>> contracts;
    private final MultivaluedMap<Integer, ClientRequestFilter> requestFilters;
    private final MultivaluedMap<Integer, ClientResponseFilter> responseFilters;
    private final MultivaluedMap<Integer, WriterInterceptor> writerInterceptors;
    private final MultivaluedMap<Integer, ReaderInterceptor> readerInterceptors;
    private final MultivaluedMap<Class<?>, ResourceWriter> resourceWriters;
    private final MultivaluedMap<Class<?>, ResourceReader> resourceReaders;
    private final MultivaluedMap<Class<?>, RxInvokerProvider<?>> rxInvokerProviders;

    public ConfigurationImpl(RuntimeType runtimeType) {
        this.runtimeType = runtimeType;
        this.properties = new HashMap<String, Object>();
        this.allInstances = new HashMap();
        this.enabledFeatures = new ArrayList<Feature>();
        this.contracts = new HashMap();
        this.requestFilters = new MultivaluedTreeMap<Integer, ClientRequestFilter>();
        this.responseFilters = new MultivaluedTreeMap(Collections.reverseOrder());
        this.readerInterceptors = new MultivaluedTreeMap<Integer, ReaderInterceptor>();
        this.writerInterceptors = new MultivaluedTreeMap(Collections.reverseOrder());
        this.resourceReaders = new QuarkusMultivaluedHashMap();
        this.resourceWriters = new QuarkusMultivaluedHashMap();
        this.rxInvokerProviders = new QuarkusMultivaluedHashMap();
    }

    public ConfigurationImpl(Configuration configuration) {
        this.runtimeType = configuration.getRuntimeType();
        this.properties = new HashMap<String, Object>(configuration.getProperties());
        if (configuration instanceof ConfigurationImpl) {
            ConfigurationImpl configurationImpl = (ConfigurationImpl)configuration;
            this.enabledFeatures = new ArrayList<Feature>(configurationImpl.enabledFeatures);
            this.contracts = new HashMap(configurationImpl.contracts);
            this.allInstances = new HashMap(configurationImpl.allInstances);
            this.requestFilters = new MultivaluedTreeMap<Integer, ClientRequestFilter>();
            this.requestFilters.putAll(configurationImpl.requestFilters);
            this.responseFilters = new MultivaluedTreeMap(Collections.reverseOrder());
            this.responseFilters.putAll(configurationImpl.responseFilters);
            this.readerInterceptors = new MultivaluedTreeMap<Integer, ReaderInterceptor>();
            this.readerInterceptors.putAll(configurationImpl.readerInterceptors);
            this.writerInterceptors = new MultivaluedTreeMap<Integer, WriterInterceptor>();
            this.writerInterceptors.putAll(configurationImpl.writerInterceptors);
            this.resourceReaders = new QuarkusMultivaluedHashMap();
            this.resourceReaders.putAll(configurationImpl.resourceReaders);
            this.resourceWriters = new QuarkusMultivaluedHashMap();
            this.resourceWriters.putAll(configurationImpl.resourceWriters);
            this.rxInvokerProviders = new QuarkusMultivaluedHashMap();
            this.rxInvokerProviders.putAll(configurationImpl.rxInvokerProviders);
        } else {
            this.allInstances = new HashMap();
            this.enabledFeatures = new ArrayList<Feature>();
            this.contracts = new HashMap();
            this.requestFilters = new MultivaluedTreeMap<Integer, ClientRequestFilter>();
            this.responseFilters = new MultivaluedTreeMap(Collections.reverseOrder());
            this.readerInterceptors = new MultivaluedTreeMap<Integer, ReaderInterceptor>();
            this.writerInterceptors = new MultivaluedTreeMap<Integer, WriterInterceptor>();
            this.resourceReaders = new QuarkusMultivaluedHashMap();
            this.resourceWriters = new QuarkusMultivaluedHashMap();
            this.rxInvokerProviders = new QuarkusMultivaluedHashMap();
            for (Object i : configuration.getInstances()) {
                this.register(i);
            }
        }
    }

    public RuntimeType getRuntimeType() {
        return this.runtimeType;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public boolean isEnabled(Feature feature) {
        return this.enabledFeatures.contains(feature);
    }

    public boolean isEnabled(Class<? extends Feature> featureClass) {
        for (Feature enabledFeature : this.enabledFeatures) {
            if (!enabledFeature.getClass().equals(featureClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isRegistered(Object component) {
        return this.allInstances.get(component.getClass()) == component;
    }

    public boolean isRegistered(Class<?> componentClass) {
        return this.allInstances.containsKey(componentClass);
    }

    public Map<Class<?>, Integer> getContracts(Class<?> componentClass) {
        Map<Class<?>, Integer> componentContracts = this.contracts.get(componentClass);
        if (componentContracts == null) {
            return Collections.emptyMap();
        }
        return componentContracts;
    }

    public Set<Class<?>> getClasses() {
        return new HashSet(this.allInstances.keySet());
    }

    public Set<Object> getInstances() {
        return new HashSet<Object>(this.allInstances.values());
    }

    public void addEnabledFeature(Feature feature) {
        this.enabledFeatures.add(feature);
    }

    public String toString(Object value) {
        return value.toString();
    }

    public void property(String name, Object value) {
        this.properties.put(name, value);
    }

    public void register(Class<?> componentClass) {
        try {
            this.register(componentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void register(Class<?> componentClass, int priority) {
        try {
            this.register(componentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), priority);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void register(Class<?> componentClass, Class<?> ... contracts) {
        try {
            this.register(componentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), contracts);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void register(Object component) {
        this.register(component, (Integer)null);
    }

    private void register(Object component, Integer priority) {
        Type[] args;
        ConstrainedTo constrainedTo;
        Class<?> componentClass;
        if (this.allInstances.containsKey(component.getClass())) {
            return;
        }
        boolean added = false;
        ArrayList<Class<MessageBodyWriter>> contractableClasses = new ArrayList<Class<MessageBodyWriter>>();
        if (component instanceof Feature) {
            contractableClasses.add(Feature.class);
            Feature thisFeature = (Feature)component;
            added = true;
            if (thisFeature.configure((FeatureContext)new ConfigFeatureContext())) {
                this.enabledFeatures.add(thisFeature);
            }
        }
        if (component instanceof ClientRequestFilter) {
            contractableClasses.add(ClientRequestFilter.class);
            added = true;
            int effectivePriority = priority != null ? priority.intValue() : this.determinePriority(component);
            this.requestFilters.add((Object)effectivePriority, (Object)((ClientRequestFilter)component));
        }
        if (component instanceof ClientResponseFilter) {
            contractableClasses.add(ClientRequestFilter.class);
            added = true;
            int effectivePriority = priority != null ? priority.intValue() : this.determinePriority(component);
            this.responseFilters.add((Object)effectivePriority, (Object)((ClientResponseFilter)component));
        }
        if (component instanceof WriterInterceptor) {
            contractableClasses.add(WriterInterceptor.class);
            added = true;
            int effectivePriority = priority != null ? priority.intValue() : this.determinePriority(component);
            this.writerInterceptors.add((Object)effectivePriority, (Object)((WriterInterceptor)component));
        }
        if (component instanceof ReaderInterceptor) {
            contractableClasses.add(ReaderInterceptor.class);
            added = true;
            int effectivePriority = priority != null ? priority.intValue() : this.determinePriority(component);
            this.readerInterceptors.add((Object)effectivePriority, (Object)((ReaderInterceptor)component));
        }
        if (component instanceof MessageBodyReader) {
            contractableClasses.add(MessageBodyReader.class);
            added = true;
            componentClass = component.getClass();
            constrainedTo = componentClass.getAnnotation(ConstrainedTo.class);
            if (constrainedTo == null || constrainedTo.value() == this.runtimeType) {
                ResourceReader resourceReader = new ResourceReader();
                resourceReader.setFactory(new UnmanagedBeanFactory<Object>(component));
                Consumes consumes = componentClass.getAnnotation(Consumes.class);
                resourceReader.setMediaTypeStrings(consumes != null ? Arrays.asList(consumes.value()) : WILDCARD_STRING_LIST);
                args = Types.findParameterizedTypes(componentClass, MessageBodyReader.class);
                this.resourceReaders.add(args != null && args.length == 1 ? Types.getRawType(args[0]) : Object.class, (Object)resourceReader);
            }
        }
        if (component instanceof MessageBodyWriter) {
            contractableClasses.add(MessageBodyWriter.class);
            added = true;
            componentClass = component.getClass();
            constrainedTo = componentClass.getAnnotation(ConstrainedTo.class);
            if (constrainedTo == null || constrainedTo.value() == this.runtimeType) {
                ResourceWriter resourceWriter = new ResourceWriter();
                resourceWriter.setFactory(new UnmanagedBeanFactory<Object>(component));
                Produces produces = componentClass.getAnnotation(Produces.class);
                resourceWriter.setMediaTypeStrings(produces != null ? Arrays.asList(produces.value()) : WILDCARD_STRING_LIST);
                args = Types.findParameterizedTypes(componentClass, MessageBodyWriter.class);
                this.resourceWriters.add(args != null && args.length == 1 ? Types.getRawType(args[0]) : Object.class, (Object)resourceWriter);
            }
        }
        if (component instanceof RxInvokerProvider) {
            added = true;
            componentClass = component.getClass();
            Type[] args2 = Types.findParameterizedTypes(componentClass, RxInvokerProvider.class);
            this.rxInvokerProviders.add(args2 != null && args2.length == 1 ? Types.getRawType(args2[0]) : Object.class, (Object)((RxInvokerProvider)component));
        }
        if (added) {
            this.allInstances.put(component.getClass(), component);
            HashMap<Class, Integer> contracts = new HashMap<Class, Integer>();
            for (Class clazz : contractableClasses) {
                contracts.put(clazz, priority);
            }
            this.contracts.put(component.getClass(), contracts);
        }
    }

    public void register(Object component, Class<?>[] contracts) {
        if (contracts == null || contracts.length == 0) {
            return;
        }
        HashMap priorities = new HashMap();
        for (Class<?> i : contracts) {
            priorities.put(i, this.determinePriority(i));
        }
        this.register(component, priorities);
    }

    public void register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        try {
            this.register(componentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), contracts);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void register(Object component, Map<Class<?>, Integer> componentContracts) {
        Type[] args;
        ConstrainedTo constrainedTo;
        if (componentContracts == null || componentContracts.isEmpty()) {
            return;
        }
        Class<?> componentClass = component.getClass();
        if (this.allInstances.containsKey(componentClass)) {
            return;
        }
        boolean added = false;
        Integer priority = componentContracts.get(Feature.class);
        if (component instanceof Feature && priority != null) {
            Feature thisFeature = (Feature)component;
            added = true;
            if (thisFeature.configure((FeatureContext)new ConfigFeatureContext())) {
                this.enabledFeatures.add(priority, (Feature)component);
            }
        }
        priority = componentContracts.get(ClientRequestFilter.class);
        if (component instanceof ClientRequestFilter && priority != null) {
            added = true;
            this.requestFilters.add((Object)priority, (Object)((ClientRequestFilter)component));
        }
        priority = componentContracts.get(ClientResponseFilter.class);
        if (component instanceof ClientResponseFilter && priority != null) {
            added = true;
            this.responseFilters.add((Object)priority, (Object)((ClientResponseFilter)component));
        }
        priority = componentContracts.get(WriterInterceptor.class);
        if (component instanceof WriterInterceptor && priority != null) {
            added = true;
            this.writerInterceptors.add((Object)priority, (Object)((WriterInterceptor)component));
        }
        priority = componentContracts.get(ReaderInterceptor.class);
        if (component instanceof ReaderInterceptor && priority != null) {
            added = true;
            this.readerInterceptors.add((Object)priority, (Object)((ReaderInterceptor)component));
        }
        priority = componentContracts.get(MessageBodyReader.class);
        if (component instanceof MessageBodyReader && priority != null) {
            added = true;
            constrainedTo = componentClass.getAnnotation(ConstrainedTo.class);
            if (constrainedTo == null || constrainedTo.value() == this.runtimeType) {
                ResourceReader resourceReader = new ResourceReader();
                resourceReader.setFactory(new UnmanagedBeanFactory<Object>(component));
                Consumes consumes = componentClass.getAnnotation(Consumes.class);
                resourceReader.setMediaTypeStrings(consumes != null ? Arrays.asList(consumes.value()) : WILDCARD_STRING_LIST);
                args = Types.findParameterizedTypes(componentClass, MessageBodyReader.class);
                this.resourceReaders.add(args != null && args.length == 1 ? Types.getRawType(args[0]) : Object.class, (Object)resourceReader);
            }
        }
        priority = componentContracts.get(MessageBodyWriter.class);
        if (component instanceof MessageBodyWriter && priority != null) {
            added = true;
            constrainedTo = componentClass.getAnnotation(ConstrainedTo.class);
            if (constrainedTo == null || constrainedTo.value() == this.runtimeType) {
                ResourceWriter resourceWriter = new ResourceWriter();
                resourceWriter.setFactory(new UnmanagedBeanFactory<Object>(component));
                Produces produces = componentClass.getAnnotation(Produces.class);
                resourceWriter.setMediaTypeStrings(produces != null ? Arrays.asList(produces.value()) : WILDCARD_STRING_LIST);
                args = Types.findParameterizedTypes(componentClass, MessageBodyWriter.class);
                this.resourceWriters.add(args != null && args.length == 1 ? Types.getRawType(args[0]) : Object.class, (Object)resourceWriter);
            }
        }
        if (added) {
            this.allInstances.put(componentClass, component);
            this.contracts.put(componentClass, componentContracts);
        }
    }

    public void register(Object component, int priority) {
        this.register(component, (Integer)priority);
    }

    public List<ClientRequestFilter> getRequestFilters() {
        if (this.requestFilters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ClientRequestFilter> result = new ArrayList<ClientRequestFilter>(this.requestFilters.size() * 2);
        for (List requestFilters : this.requestFilters.values()) {
            result.addAll(requestFilters);
        }
        return result;
    }

    public List<ClientResponseFilter> getResponseFilters() {
        if (this.responseFilters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ClientResponseFilter> result = new ArrayList<ClientResponseFilter>(this.responseFilters.size() * 2);
        for (List responseFilters : this.responseFilters.values()) {
            result.addAll(responseFilters);
        }
        return result;
    }

    public List<WriterInterceptor> getWriterInterceptors() {
        if (this.writerInterceptors.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<WriterInterceptor> result = new ArrayList<WriterInterceptor>(this.writerInterceptors.size() * 2);
        for (List writerInterceptors : this.writerInterceptors.values()) {
            result.addAll(writerInterceptors);
        }
        return result;
    }

    public List<ReaderInterceptor> getReaderInterceptors() {
        if (this.readerInterceptors.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ReaderInterceptor> result = new ArrayList<ReaderInterceptor>(this.readerInterceptors.size() * 2);
        for (List readerInterceptors : this.readerInterceptors.values()) {
            result.addAll(readerInterceptors);
        }
        return result;
    }

    public RxInvokerProvider<?> getRxInvokerProvider(Class<?> wantedClass) {
        List candidates = (List)this.rxInvokerProviders.get(wantedClass);
        if (candidates == null) {
            return null;
        }
        for (RxInvokerProvider invokerProvider : candidates) {
            if (!invokerProvider.isProviderFor(wantedClass)) continue;
            return invokerProvider;
        }
        return null;
    }

    private int determinePriority(Object object) {
        return this.determinePriority(object.getClass());
    }

    private int determinePriority(Class<?> object) {
        Priority priority = object.getDeclaredAnnotation(Priority.class);
        if (priority == null) {
            return 5000;
        }
        return priority.value();
    }

    public MultivaluedMap<Class<?>, ResourceReader> getResourceReaders() {
        return this.resourceReaders;
    }

    public MultivaluedMap<Class<?>, ResourceWriter> getResourceWriters() {
        return this.resourceWriters;
    }

    private class ConfigFeatureContext
    implements FeatureContext {
        private ConfigFeatureContext() {
        }

        public Configuration getConfiguration() {
            return ConfigurationImpl.this;
        }

        public FeatureContext property(String name, Object value) {
            ConfigurationImpl.this.property(name, value);
            return this;
        }

        public FeatureContext register(Class<?> componentClass) {
            ConfigurationImpl.this.register(componentClass);
            return this;
        }

        public FeatureContext register(Class<?> componentClass, int priority) {
            ConfigurationImpl.this.register(componentClass, priority);
            return this;
        }

        public FeatureContext register(Class<?> componentClass, Class<?> ... contracts) {
            ConfigurationImpl.this.register(componentClass, contracts);
            return this;
        }

        public FeatureContext register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
            ConfigurationImpl.this.register(componentClass, contracts);
            return this;
        }

        public FeatureContext register(Object component) {
            ConfigurationImpl.this.register(component);
            return this;
        }

        public FeatureContext register(Object component, int priority) {
            ConfigurationImpl.this.register(component, priority);
            return this;
        }

        public FeatureContext register(Object component, Class<?> ... contracts) {
            ConfigurationImpl.this.register(component, contracts);
            return this;
        }

        public FeatureContext register(Object component, Map<Class<?>, Integer> contracts) {
            ConfigurationImpl.this.register(component, contracts);
            return this;
        }
    }
}

