/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.processor.generation.filters;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.server.processor.generation.filters.CustomFilterGenerator;
import org.jboss.resteasy.reactive.server.processor.util.GeneratedClass;
import org.jboss.resteasy.reactive.server.processor.util.GeneratedClassOutput;
import org.jboss.resteasy.reactive.server.processor.util.ResteasyReactiveServerDotNames;

public class FilterGeneration {
    public static List<GeneratedFilter> generate(IndexView index, Set<DotName> unwrappableTypes, Set<String> additionalBeanAnnotations) {
        MethodInfo methodInfo;
        ArrayList<GeneratedFilter> ret = new ArrayList<GeneratedFilter>();
        for (AnnotationInstance instance : index.getAnnotations(ResteasyReactiveServerDotNames.SERVER_REQUEST_FILTER)) {
            AnnotationValue nonBlockingRequiredValue;
            AnnotationValue preMatchingValue;
            if (instance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            methodInfo = instance.target().asMethod();
            GeneratedClassOutput output = new GeneratedClassOutput();
            String generatedClassName = CustomFilterGenerator.generateContainerRequestFilter(methodInfo, output, unwrappableTypes, additionalBeanAnnotations);
            Integer priority = null;
            boolean preMatching = false;
            boolean nonBlockingRequired = false;
            HashSet<String> nameBindingNames = new HashSet<String>();
            AnnotationValue priorityValue = instance.value("priority");
            if (priorityValue != null) {
                priority = priorityValue.asInt();
            }
            if ((preMatchingValue = instance.value("preMatching")) != null) {
                preMatching = preMatchingValue.asBoolean();
            }
            if ((nonBlockingRequiredValue = instance.value("nonBlocking")) != null) {
                nonBlockingRequired = nonBlockingRequiredValue.asBoolean();
            }
            List annotations = methodInfo.annotations();
            for (AnnotationInstance annotation : annotations) {
                DotName annotationDotName;
                ClassInfo annotationClassInfo;
                if (ResteasyReactiveServerDotNames.SERVER_REQUEST_FILTER.equals((Object)annotation.name()) || (annotationClassInfo = index.getClassByName(annotationDotName = annotation.name())) == null || annotationClassInfo.classAnnotation(ResteasyReactiveDotNames.NAME_BINDING) == null) continue;
                nameBindingNames.add(annotationDotName.toString());
            }
            ret.add(new GeneratedFilter(output.getOutput(), generatedClassName, methodInfo.declaringClass().name().toString(), true, priority, preMatching, nonBlockingRequired, nameBindingNames));
        }
        for (AnnotationInstance instance : index.getAnnotations(ResteasyReactiveServerDotNames.SERVER_RESPONSE_FILTER)) {
            if (instance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            methodInfo = instance.target().asMethod();
            Integer priority = null;
            HashSet<String> nameBindingNames = new HashSet<String>();
            GeneratedClassOutput output = new GeneratedClassOutput();
            String generatedClassName = CustomFilterGenerator.generateContainerResponseFilter(methodInfo, output, unwrappableTypes, additionalBeanAnnotations);
            AnnotationValue priorityValue = instance.value("priority");
            if (priorityValue != null) {
                priority = priorityValue.asInt();
            }
            List annotations = methodInfo.annotations();
            for (AnnotationInstance annotation : annotations) {
                DotName annotationDotName;
                ClassInfo annotationClassInfo;
                if (ResteasyReactiveServerDotNames.SERVER_REQUEST_FILTER.equals((Object)annotation.name()) || (annotationClassInfo = index.getClassByName(annotationDotName = annotation.name())) == null || annotationClassInfo.classAnnotation(ResteasyReactiveDotNames.NAME_BINDING) == null) continue;
                nameBindingNames.add(annotationDotName.toString());
            }
            ret.add(new GeneratedFilter(output.getOutput(), generatedClassName, methodInfo.declaringClass().name().toString(), false, priority, false, false, nameBindingNames));
        }
        return ret;
    }

    public static class GeneratedFilter {
        final List<GeneratedClass> generatedClasses;
        final String generatedClassName;
        final String declaringClassName;
        final boolean requestFilter;
        final Integer priority;
        final boolean preMatching;
        final boolean nonBlocking;
        final Set<String> nameBindingNames;

        public GeneratedFilter(List<GeneratedClass> generatedClasses, String generatedClassName, String declaringClassName, boolean requestFilter, Integer priority, boolean preMatching, boolean nonBlocking, Set<String> nameBindingNames) {
            this.generatedClasses = generatedClasses;
            this.generatedClassName = generatedClassName;
            this.declaringClassName = declaringClassName;
            this.requestFilter = requestFilter;
            this.priority = priority;
            this.preMatching = preMatching;
            this.nonBlocking = nonBlocking;
            this.nameBindingNames = nameBindingNames;
        }

        public String getGeneratedClassName() {
            return this.generatedClassName;
        }

        public String getDeclaringClassName() {
            return this.declaringClassName;
        }

        public boolean isRequestFilter() {
            return this.requestFilter;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public boolean isPreMatching() {
            return this.preMatching;
        }

        public boolean isNonBlocking() {
            return this.nonBlocking;
        }

        public List<GeneratedClass> getGeneratedClasses() {
            return this.generatedClasses;
        }

        public Set<String> getNameBindingNames() {
            return this.nameBindingNames;
        }
    }
}

