/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.serialization;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import org.jboss.resteasy.reactive.common.util.MediaTypeHelper;
import org.jboss.resteasy.reactive.server.core.EncodedMediaType;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.core.serialization.EntityWriter;
import org.jboss.resteasy.reactive.server.spi.ServerHttpRequest;
import org.jboss.resteasy.reactive.server.spi.ServerHttpResponse;

public class DynamicEntityWriter
implements EntityWriter {
    private static final MessageBodyWriter<?>[] EMPTY_ARRAY = new MessageBodyWriter[0];
    private final ServerSerialisers serialisers;

    public DynamicEntityWriter(ServerSerialisers serialisers) {
        this.serialisers = serialisers;
    }

    @Override
    public void write(ResteasyReactiveRequestContext context, Object entity) throws IOException {
        EncodedMediaType producesMediaType = context.getResponseContentType();
        MessageBodyWriter<?>[] writers = null;
        MediaType serverSerializersMediaType = null;
        if (producesMediaType == null) {
            ServerSerialisers.BestMatchingServerWriterResult bestMatchingServerWriterResult;
            MediaType selectedMediaType = null;
            boolean mediaTypeComesFromClient = false;
            ServerHttpRequest vertxRequest = context.serverRequest();
            if (context.getTarget() != null && context.getTarget().getProduces() != null) {
                MediaType negotiatedMediaType = (MediaType)context.getTarget().getProduces().negotiateProduces(vertxRequest.getRequestHeader("Accept")).getKey();
                List writersList = this.serialisers.findWriters(null, entity.getClass(), negotiatedMediaType, RuntimeType.SERVER);
                if (!writersList.isEmpty()) {
                    MediaType[] sortedOriginalMediaTypes;
                    writers = writersList.toArray(EMPTY_ARRAY);
                    for (MediaType methodMediaType : sortedOriginalMediaTypes = context.getTarget().getProduces().getSortedOriginalMediaTypes()) {
                        if (!methodMediaType.isCompatible(negotiatedMediaType)) continue;
                        selectedMediaType = methodMediaType;
                        break;
                    }
                    if (selectedMediaType == null) {
                        selectedMediaType = sortedOriginalMediaTypes[0];
                    }
                }
            } else if (vertxRequest.getRequestHeader("Accept") != null && !"*/*".equals(vertxRequest.getRequestHeader("Accept")) && !(bestMatchingServerWriterResult = this.serialisers.findBestMatchingServerWriter(null, entity.getClass(), vertxRequest)).isEmpty()) {
                selectedMediaType = bestMatchingServerWriterResult.getSelectedMediaType();
                mediaTypeComesFromClient = true;
                writers = bestMatchingServerWriterResult.getMessageBodyWriters().toArray(ServerSerialisers.NO_WRITER);
            }
            if (writers == null) {
                ServerSerialisers.NoMediaTypeResult writerNoMediaType = this.serialisers.findWriterNoMediaType(context, entity, this.serialisers, RuntimeType.SERVER);
                writers = writerNoMediaType.getWriters();
                selectedMediaType = writerNoMediaType.getMediaType();
            }
            if (selectedMediaType != null) {
                if (MediaTypeHelper.isUnsupportedWildcardSubtype(selectedMediaType) && !mediaTypeComesFromClient) {
                    ServerSerialisers.encodeResponseHeaders(context);
                    ServerHttpResponse httpServerResponse = context.serverResponse();
                    httpServerResponse.setStatusCode(Response.Status.NOT_ACCEPTABLE.getStatusCode());
                    httpServerResponse.end();
                    return;
                }
                serverSerializersMediaType = selectedMediaType;
                context.setResponseContentType(selectedMediaType);
                context.serverResponse().addResponseHeader("Content-Type", context.getResponseContentType().toString());
            }
        } else {
            writers = this.serialisers.findWriters(null, entity.getClass(), producesMediaType.getMediaType(), RuntimeType.SERVER).toArray(ServerSerialisers.NO_WRITER);
        }
        for (MessageBodyWriter<?> w : writers) {
            if (!ServerSerialisers.invokeWriter(context, entity, w, this.serialisers, serverSerializersMediaType)) continue;
            return;
        }
        throw new InternalServerErrorException("Could not find MessageBodyWriter for " + entity.getClass(), Response.serverError().build());
    }
}

