/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.strategy.standard;

import com.google.common.base.Preconditions;
import io.shardingsphere.core.api.algorithm.sharding.ListShardingValue;
import io.shardingsphere.core.api.algorithm.sharding.PreciseShardingValue;
import io.shardingsphere.core.api.algorithm.sharding.RangeShardingValue;
import io.shardingsphere.core.api.algorithm.sharding.ShardingValue;
import io.shardingsphere.core.api.algorithm.sharding.standard.PreciseShardingAlgorithm;
import io.shardingsphere.core.api.algorithm.sharding.standard.RangeShardingAlgorithm;
import io.shardingsphere.core.api.config.strategy.StandardShardingStrategyConfiguration;
import io.shardingsphere.core.routing.strategy.ShardingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public final class StandardShardingStrategy
implements ShardingStrategy {
    private final String shardingColumn;
    private final PreciseShardingAlgorithm preciseShardingAlgorithm;
    private final RangeShardingAlgorithm rangeShardingAlgorithm;

    public StandardShardingStrategy(StandardShardingStrategyConfiguration standardShardingStrategyConfig) {
        Preconditions.checkNotNull((Object)standardShardingStrategyConfig.getShardingColumn(), (Object)"Sharding column cannot be null.");
        Preconditions.checkNotNull((Object)standardShardingStrategyConfig.getPreciseShardingAlgorithm(), (Object)"precise sharding algorithm cannot be null.");
        this.shardingColumn = standardShardingStrategyConfig.getShardingColumn();
        this.preciseShardingAlgorithm = standardShardingStrategyConfig.getPreciseShardingAlgorithm();
        this.rangeShardingAlgorithm = standardShardingStrategyConfig.getRangeShardingAlgorithm();
    }

    @Override
    public Collection<String> doSharding(Collection<String> availableTargetNames, Collection<ShardingValue> shardingValues) {
        ShardingValue shardingValue = shardingValues.iterator().next();
        Collection<String> shardingResult = shardingValue instanceof ListShardingValue ? this.doSharding(availableTargetNames, (ListShardingValue)shardingValue) : this.doSharding(availableTargetNames, (RangeShardingValue)shardingValue);
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(shardingResult);
        return result;
    }

    private Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<?> shardingValue) {
        if (null == this.rangeShardingAlgorithm) {
            throw new UnsupportedOperationException("Cannot find range sharding strategy in sharding rule.");
        }
        return this.rangeShardingAlgorithm.doSharding(availableTargetNames, shardingValue);
    }

    private Collection<String> doSharding(Collection<String> availableTargetNames, ListShardingValue<?> shardingValue) {
        LinkedList<String> result = new LinkedList<String>();
        for (PreciseShardingValue each : this.transferToPreciseShardingValues(shardingValue)) {
            result.add(this.preciseShardingAlgorithm.doSharding(availableTargetNames, each));
        }
        return result;
    }

    private List<PreciseShardingValue> transferToPreciseShardingValues(ListShardingValue<?> shardingValue) {
        ArrayList<PreciseShardingValue> result = new ArrayList<PreciseShardingValue>(shardingValue.getValues().size());
        for (Comparable each : shardingValue.getValues()) {
            result.add(new PreciseShardingValue<Comparable>(shardingValue.getLogicTableName(), shardingValue.getColumnName(), each));
        }
        return result;
    }

    @Override
    public Collection<String> getShardingColumns() {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.add(this.shardingColumn);
        return result;
    }
}

