/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.type;

import com.google.common.base.Optional;
import io.shardingsphere.core.routing.type.RoutingTable;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class TableUnit {
    private final String dataSourceName;
    private final List<RoutingTable> routingTables = new LinkedList<RoutingTable>();

    public Optional<RoutingTable> findRoutingTable(String dataSourceName, String actualTableName) {
        for (RoutingTable each : this.routingTables) {
            if (!dataSourceName.equalsIgnoreCase(this.dataSourceName) || !each.getActualTableName().equalsIgnoreCase(actualTableName)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    public Set<String> getActualTableNames(String dataSourceName, String logicTableName) {
        HashSet<String> result = new HashSet<String>(this.routingTables.size(), 1.0f);
        for (RoutingTable each : this.routingTables) {
            if (!dataSourceName.equalsIgnoreCase(this.dataSourceName) || !each.getLogicTableName().equalsIgnoreCase(logicTableName)) continue;
            result.add(each.getActualTableName());
        }
        return result;
    }

    public Set<String> getLogicTableNames(String dataSourceName) {
        HashSet<String> result = new HashSet<String>(this.routingTables.size(), 1.0f);
        for (RoutingTable each : this.routingTables) {
            if (!dataSourceName.equalsIgnoreCase(this.dataSourceName)) continue;
            result.add(each.getLogicTableName());
        }
        return result;
    }

    @ConstructorProperties(value={"dataSourceName"})
    public TableUnit(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public List<RoutingTable> getRoutingTables() {
        return this.routingTables;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableUnit)) {
            return false;
        }
        TableUnit other = (TableUnit)o;
        String this$dataSourceName = this.getDataSourceName();
        String other$dataSourceName = other.getDataSourceName();
        if (this$dataSourceName == null ? other$dataSourceName != null : !this$dataSourceName.equals(other$dataSourceName)) {
            return false;
        }
        List<RoutingTable> this$routingTables = this.getRoutingTables();
        List<RoutingTable> other$routingTables = other.getRoutingTables();
        return !(this$routingTables == null ? other$routingTables != null : !((Object)this$routingTables).equals(other$routingTables));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dataSourceName = this.getDataSourceName();
        result = result * 59 + ($dataSourceName == null ? 0 : $dataSourceName.hashCode());
        List<RoutingTable> $routingTables = this.getRoutingTables();
        result = result * 59 + ($routingTables == null ? 0 : ((Object)$routingTables).hashCode());
        return result;
    }

    public String toString() {
        return "TableUnit(dataSourceName=" + this.getDataSourceName() + ", routingTables=" + this.getRoutingTables() + ")";
    }
}

