/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.smallrye.reactive.messaging.kafka.KafkaConnectorIncomingConfiguration;

public class RuntimeKafkaSourceConfiguration {
    private final String channel;
    private final boolean pauseIfNoRequests;
    private final int maxQueueSizeFactor;
    private final int retryAttempts;
    private final boolean retry;
    private final int retryMaxWait;
    private final int maxPollRecords;
    private final int closeTimeout;

    public RuntimeKafkaSourceConfiguration(String channel, boolean pauseIfNoRequests, int maxQueueSizeFactor, int retryAttempts, boolean retry, int retryMaxWait, int maxPollRecords, int closeTimeout) {
        this.channel = channel;
        this.pauseIfNoRequests = pauseIfNoRequests;
        this.maxQueueSizeFactor = maxQueueSizeFactor;
        this.retryAttempts = retryAttempts;
        this.retry = retry;
        this.retryMaxWait = retryMaxWait;
        this.maxPollRecords = maxPollRecords;
        this.closeTimeout = closeTimeout;
    }

    public static RuntimeKafkaSourceConfiguration buildFromConfiguration(KafkaConnectorIncomingConfiguration config) {
        return new RuntimeKafkaSourceConfiguration(config.getChannel(), config.getPauseIfNoRequests(), config.getMaxQueueSizeFactor(), config.getRetryAttempts(), config.getRetry(), config.getRetryMaxWait(), config.config().getOptionalValue("max.poll.records", Integer.class).orElse(500), config.config().getOptionalValue("default.api.timeout.ms", Integer.class).orElse(1000));
    }

    public String getChannel() {
        return this.channel;
    }

    public boolean getPauseIfNoRequests() {
        return this.pauseIfNoRequests;
    }

    public int getMaxQueueSizeFactor() {
        return this.maxQueueSizeFactor;
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public boolean getRetry() {
        return this.retry;
    }

    public int getRetryMaxWait() {
        return this.retryMaxWait;
    }

    public int getMaxPollRecords() {
        return this.maxPollRecords;
    }

    public int getCloseTimeout() {
        return this.closeTimeout;
    }
}

