package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import java.lang.Class;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Timeout;

/**
 * Automatically generated from the {@link TimeoutConfig} config interface, do not modify.
 */
public final class TimeoutConfigImpl implements TimeoutConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final Timeout instance;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    /**
     * Cached value of the {@code Timeout.value} annotation member; {@code null} if not looked up yet.
     */
    private Long _value;

    /**
     * Cached value of the {@code Timeout.unit} annotation member; {@code null} if not looked up yet.
     */
    private ChronoUnit _unit;

    private TimeoutConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.timeout;
        this.onMethod = method.annotationsPresentDirectly.contains(Timeout.class);
    }

    public static TimeoutConfigImpl create(FaultToleranceMethod method) {
        if (method.timeout == null) {
            return null;
        }
        if (!Config.isEnabled(Timeout.class, method.method)) {
            return null;
        }
        return new TimeoutConfigImpl(method);
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Timeout.class;
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    @Override
    public long value() {
        if (_value == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                _value = config.getOptionalValue(getConfigKeyForMethod("value"), long.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                _value = config.getOptionalValue(getConfigKeyForClass("value"), long.class).orElse(null);
            }
            if (_value == null) {
                // <annotation>/<parameter>
                _value = config.getOptionalValue("Timeout" + "/" + "value", long.class).orElse(null);
            }
            if (_value == null) {
                // annotation value
                _value = instance.value();
            }
        }
        return _value;
    }

    @Override
    public ChronoUnit unit() {
        if (_unit == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                _unit = config.getOptionalValue(getConfigKeyForMethod("unit"), ChronoUnit.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                _unit = config.getOptionalValue(getConfigKeyForClass("unit"), ChronoUnit.class).orElse(null);
            }
            if (_unit == null) {
                // <annotation>/<parameter>
                _unit = config.getOptionalValue("Timeout" + "/" + "unit", ChronoUnit.class).orElse(null);
            }
            if (_unit == null) {
                // annotation value
                _unit = instance.unit();
            }
        }
        return _unit;
    }

    private String getConfigKeyForMethod(String key) {
        return method.declaringClass.getName() + "/" + method.name + "/" + "Timeout" + "/" + key;
    }

    private String getConfigKeyForClass(String key) {
        return method.declaringClass.getName() + "/" + "Timeout" + "/" + key;
    }
}
