/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.functional.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.formats.FunctionalSyntaxDocumentFormat;
import org.semanticweb.owlapi.functional.parser.OWLFunctionalSyntaxParserConstants;
import org.semanticweb.owlapi.functional.parser.ParseException;
import org.semanticweb.owlapi.functional.parser.Token;
import org.semanticweb.owlapi.functional.parser.TokenManager;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.util.EscapeUtils;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWLFacet;

class OWLFunctionalSyntaxParser
implements OWLFunctionalSyntaxParserConstants {
    private OWLOntologyManager man;
    private OWLOntologyLoaderConfiguration configuration;
    private OWLOntology ontology;
    private OWLDataFactory dataFactory;
    private Map<String, IRI> string2IRI;
    private Map<String, String> prefixMap;
    private IRI ontologyIRI;
    private boolean ignoreAnnotationsAndDeclarations = false;
    private Set<OWLAnnotation> currentAnnotations;
    public TokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[49];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public void setUp(OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) {
        this.man = ontology.getOWLOntologyManager();
        this.ontology = ontology;
        this.configuration = configuration;
        this.dataFactory = this.man.getOWLDataFactory();
        this.currentAnnotations = new HashSet<OWLAnnotation>();
        if (this.prefixMap == null) {
            this.prefixMap = new HashMap<String, String>();
            this.prefixMap.put("owl:", Namespaces.OWL.toString());
            this.prefixMap.put("rdf:", Namespaces.RDF.toString());
            this.prefixMap.put("rdfs:", Namespaces.RDFS.toString());
            this.prefixMap.put("xml:", Namespaces.XML.toString());
            this.prefixMap.put("xsd:", Namespaces.XSD.toString());
        }
        this.string2IRI = new HashMap<String, IRI>();
    }

    public IRI getIRI(String s) {
        IRI iri = this.string2IRI.get(s);
        if (iri == null) {
            if (s.charAt(0) == '<') {
                iri = IRI.create((String)s.substring(1, s.length() - 1));
            } else {
                int colonIndex = s.indexOf(58);
                String prefixName = s.substring(0, colonIndex + 1);
                String prefix = this.prefixMap.get(prefixName);
                if (prefix == null) {
                    throw new OWLRuntimeException("Undefined prefix name: " + prefixName);
                }
                String fullIRIString = prefix + s.substring(colonIndex + 1);
                iri = IRI.create((String)fullIRIString);
            }
            this.string2IRI.put(s, iri);
        }
        return iri;
    }

    public void setIgnoreAnnotationsAndDeclarations(boolean b) {
        this.ignoreAnnotationsAndDeclarations = b;
    }

    protected void applyChange(OWLOntologyChange chg) {
        this.man.applyChange(chg);
    }

    protected void addAxiom(OWLAxiom ax) {
        if (!(ax instanceof OWLAnnotationAxiom) || this.configuration.isLoadAnnotationAxioms()) {
            AddAxiom addAxiom = new AddAxiom(this.ontology, ax);
            this.applyChange((OWLOntologyChange)addAxiom);
        }
    }

    public void setPrefixes(PrefixManager nsm) {
        if (this.prefixMap == null) {
            this.prefixMap = new HashMap<String, String>();
        }
        this.prefixMap.putAll(nsm.getPrefixName2PrefixMap());
    }

    @Nonnull
    public final FunctionalSyntaxDocumentFormat parse() throws ParseException, OWLParserException, UnloadableImportException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 89: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.Prefix();
        }
        this.Ontology();
        this.jj_consume_token(0);
        FunctionalSyntaxDocumentFormat format = new FunctionalSyntaxDocumentFormat();
        for (String pn : this.prefixMap.keySet()) {
            format.setPrefix(pn, this.prefixMap.get(pn));
        }
        if ("" != null) {
            return format;
        }
        throw new Error("Missing return statement in function");
    }

    public final void Ontology() throws ParseException, OWLParserException, UnloadableImportException {
        block18: {
            boolean count = false;
            IRI versionIRI = null;
            this.jj_consume_token(14);
            this.jj_consume_token(12);
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 120: 
                case 123: {
                    this.ontologyIRI = this.IRI();
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 120: 
                        case 123: {
                            versionIRI = this.IRI();
                            break block0;
                        }
                    }
                    this.jj_la1[1] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                }
            }
            OWLOntologyID id = new OWLOntologyID(this.ontologyIRI, versionIRI);
            this.applyChange((OWLOntologyChange)new SetOntologyID(this.ontology, id));
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 16: 
                    case 24: {
                        break;
                    }
                    default: {
                        this.jj_la1[3] = this.jj_gen;
                        break block18;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 16: {
                        OWLImportsDeclaration decl = this.ImportsDeclaration();
                        this.applyChange((OWLOntologyChange)new AddImport(this.ontology, decl));
                        this.man.makeLoadImportRequest(decl, this.configuration);
                        continue block16;
                    }
                    case 24: {
                        OWLAnnotation anno = this.Annotation();
                        this.applyChange((OWLOntologyChange)new AddOntologyAnnotation(this.ontology, anno));
                        this.currentAnnotations.clear();
                        continue block16;
                    }
                }
                break;
            }
            this.jj_la1[4] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        block17: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 18: 
                case 21: 
                case 22: 
                case 23: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 45: 
                case 48: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 100: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block17;
                }
            }
            OWLAxiom ax = this.Axiom();
            this.addAxiom(ax);
            this.currentAnnotations.clear();
        }
        this.jj_consume_token(13);
    }

    public final void Prefix() throws ParseException {
        String prefixName = "";
        this.jj_consume_token(89);
        this.jj_consume_token(12);
        prefixName = this.PrefixName();
        this.jj_consume_token(118);
        IRI iri = this.FullIRI();
        this.jj_consume_token(13);
        this.prefixMap.put(prefixName, iri.toString());
    }

    public final IRI IRI() throws ParseException {
        IRI iri;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 120: {
                iri = this.FullIRI();
                break;
            }
            case 123: {
                iri = this.AbbreviatedIRI();
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return iri;
        }
        throw new Error("Missing return statement in function");
    }

    public final IRI FullIRI() throws ParseException {
        Token t = this.jj_consume_token(120);
        if ("" != null) {
            return this.getIRI(t.image);
        }
        throw new Error("Missing return statement in function");
    }

    public final IRI AbbreviatedIRI() throws ParseException {
        Token t = this.jj_consume_token(123);
        if ("" != null) {
            return this.getIRI(t.image);
        }
        throw new Error("Missing return statement in function");
    }

    public final String PrefixName() throws ParseException {
        Token t = this.jj_consume_token(121);
        if ("" != null) {
            return t.image;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassExpression ClassExpression() throws ParseException {
        OWLClass desc;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 120: 
            case 123: {
                desc = this.ClassIRI();
                break;
            }
            case 42: {
                desc = this.ObjectUnionOf();
                break;
            }
            case 49: {
                desc = this.ObjectIntersectionOf();
                break;
            }
            case 50: {
                desc = this.ObjectComplementOf();
                break;
            }
            case 41: {
                desc = this.ObjectOneOf();
                break;
            }
            case 52: {
                desc = this.ObjectSomeValuesFrom();
                break;
            }
            case 51: {
                desc = this.ObjectAllValuesFrom();
                break;
            }
            case 43: {
                desc = this.ObjectHasValue();
                break;
            }
            case 53: {
                desc = this.ObjectSelf();
                break;
            }
            case 54: {
                desc = this.ObjectMinCardinality();
                break;
            }
            case 56: {
                desc = this.ObjectExactCardinality();
                break;
            }
            case 55: {
                desc = this.ObjectMaxCardinality();
                break;
            }
            case 58: {
                desc = this.DataSomeValuesFrom();
                break;
            }
            case 57: {
                desc = this.DataAllValuesFrom();
                break;
            }
            case 59: {
                desc = this.DataHasValue();
                break;
            }
            case 60: {
                desc = this.DataMinCardinality();
                break;
            }
            case 62: {
                desc = this.DataExactCardinality();
                break;
            }
            case 61: {
                desc = this.DataMaxCardinality();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return desc;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClass ClassIRI() throws ParseException {
        IRI iri = this.IRI();
        if ("" != null) {
            return this.dataFactory.getOWLClass(iri);
        }
        throw new Error("Missing return statement in function");
    }

    public final Set<OWLClassExpression> ClassExpressionSet() throws ParseException {
        HashSet<OWLClassExpression> classExpressions = new HashSet<OWLClassExpression>();
        OWLClassExpression desc = this.ClassExpression();
        classExpressions.add(desc);
        desc = this.ClassExpression();
        classExpressions.add(desc);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 41: 
                case 42: 
                case 43: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 120: 
                case 123: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block3;
                }
            }
            desc = this.ClassExpression();
            classExpressions.add(desc);
        }
        if ("" != null) {
            return classExpressions;
        }
        throw new Error("Missing return statement in function");
    }

    public final Set<OWLIndividual> IndividualMinOneSet() throws ParseException {
        HashSet<OWLIndividual> individuals = new HashSet<OWLIndividual>();
        OWLIndividual ind = this.Individual();
        individuals.add(ind);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 120: 
                case 123: 
                case 128: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block3;
                }
            }
            ind = this.Individual();
            individuals.add(ind);
        }
        if ("" != null) {
            return individuals;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassExpression ObjectUnionOf() throws ParseException {
        this.jj_consume_token(42);
        this.jj_consume_token(12);
        Set<OWLClassExpression> classExpressions = this.ClassExpressionSet();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLObjectUnionOf(classExpressions);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassExpression ObjectIntersectionOf() throws ParseException {
        this.jj_consume_token(49);
        this.jj_consume_token(12);
        Set<OWLClassExpression> classExpressions = this.ClassExpressionSet();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLObjectIntersectionOf(classExpressions);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassExpression ObjectComplementOf() throws ParseException {
        this.jj_consume_token(50);
        this.jj_consume_token(12);
        OWLClassExpression operand = this.ClassExpression();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLObjectComplementOf(operand);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassExpression ObjectOneOf() throws ParseException {
        this.jj_consume_token(41);
        this.jj_consume_token(12);
        Set<OWLIndividual> individuals = this.IndividualMinOneSet();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLObjectOneOf(individuals);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassExpression ObjectAllValuesFrom() throws ParseException {
        this.jj_consume_token(51);
        this.jj_consume_token(12);
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        OWLClassExpression filler = this.ClassExpression();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLObjectAllValuesFrom(prop, filler);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassExpression ObjectSomeValuesFrom() throws ParseException {
        this.jj_consume_token(52);
        this.jj_consume_token(12);
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        OWLClassExpression filler = this.ClassExpression();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLObjectSomeValuesFrom(prop, filler);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassExpression ObjectHasValue() throws ParseException {
        this.jj_consume_token(43);
        this.jj_consume_token(12);
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        OWLIndividual ind = this.Individual();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLObjectHasValue(prop, ind);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassExpression ObjectSelf() throws ParseException {
        this.jj_consume_token(53);
        this.jj_consume_token(12);
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLObjectHasSelf(prop);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassExpression ObjectMinCardinality() throws ParseException {
        int cardinality = 0;
        OWLObjectPropertyExpression prop = null;
        OWLClassExpression filler = null;
        this.jj_consume_token(54);
        this.jj_consume_token(12);
        cardinality = this.Cardinality();
        prop = this.ObjectPropertyExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 41: 
            case 42: 
            case 43: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 120: 
            case 123: {
                filler = this.ClassExpression();
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        this.jj_consume_token(13);
        if (filler == null) {
            if ("" != null) {
                return this.dataFactory.getOWLObjectMinCardinality(cardinality, prop);
            }
        } else if ("" != null) {
            return this.dataFactory.getOWLObjectMinCardinality(cardinality, prop, filler);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassExpression ObjectExactCardinality() throws ParseException {
        int cardinality = 0;
        OWLObjectPropertyExpression prop = null;
        OWLClassExpression filler = null;
        this.jj_consume_token(56);
        this.jj_consume_token(12);
        cardinality = this.Cardinality();
        prop = this.ObjectPropertyExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 41: 
            case 42: 
            case 43: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 120: 
            case 123: {
                filler = this.ClassExpression();
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        this.jj_consume_token(13);
        if (filler == null) {
            if ("" != null) {
                return this.dataFactory.getOWLObjectExactCardinality(cardinality, prop);
            }
        } else if ("" != null) {
            return this.dataFactory.getOWLObjectExactCardinality(cardinality, prop, filler);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassExpression ObjectMaxCardinality() throws ParseException {
        int cardinality = 0;
        OWLObjectPropertyExpression prop = null;
        OWLClassExpression filler = null;
        this.jj_consume_token(55);
        this.jj_consume_token(12);
        cardinality = this.Cardinality();
        prop = this.ObjectPropertyExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 41: 
            case 42: 
            case 43: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 120: 
            case 123: {
                filler = this.ClassExpression();
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        this.jj_consume_token(13);
        if (filler == null) {
            if ("" != null) {
                return this.dataFactory.getOWLObjectMaxCardinality(cardinality, prop);
            }
        } else if ("" != null) {
            return this.dataFactory.getOWLObjectMaxCardinality(cardinality, prop, filler);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassExpression DataAllValuesFrom() throws ParseException {
        OWLDataPropertyExpression prop = null;
        OWLDataRange dataRange = null;
        this.jj_consume_token(57);
        this.jj_consume_token(12);
        prop = this.DataPropertyExpression();
        dataRange = this.DataRange();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLDataAllValuesFrom(prop, dataRange);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassExpression DataSomeValuesFrom() throws ParseException {
        OWLDataPropertyExpression prop = null;
        OWLDataRange dataRange = null;
        this.jj_consume_token(58);
        this.jj_consume_token(12);
        prop = this.DataPropertyExpression();
        dataRange = this.DataRange();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLDataSomeValuesFrom(prop, dataRange);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassExpression DataHasValue() throws ParseException {
        OWLDataPropertyExpression prop = null;
        OWLLiteral literal = null;
        this.jj_consume_token(59);
        this.jj_consume_token(12);
        prop = this.DataPropertyExpression();
        literal = this.Literal();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLDataHasValue(prop, literal);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassExpression DataMinCardinality() throws ParseException {
        int cardinality = 0;
        OWLDataPropertyExpression prop = null;
        OWLDataRange rng = null;
        this.jj_consume_token(60);
        this.jj_consume_token(12);
        cardinality = this.Cardinality();
        prop = this.DataPropertyExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 38: 
            case 39: 
            case 40: 
            case 46: 
            case 47: 
            case 120: 
            case 123: {
                rng = this.DataRange();
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        this.jj_consume_token(13);
        if (rng == null) {
            if ("" != null) {
                return this.dataFactory.getOWLDataMinCardinality(cardinality, prop);
            }
        } else if ("" != null) {
            return this.dataFactory.getOWLDataMinCardinality(cardinality, prop, rng);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassExpression DataExactCardinality() throws ParseException {
        int cardinality = 0;
        OWLDataPropertyExpression prop = null;
        OWLDataRange rng = null;
        this.jj_consume_token(62);
        this.jj_consume_token(12);
        cardinality = this.Cardinality();
        prop = this.DataPropertyExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 38: 
            case 39: 
            case 40: 
            case 46: 
            case 47: 
            case 120: 
            case 123: {
                rng = this.DataRange();
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        this.jj_consume_token(13);
        if (rng == null) {
            if ("" != null) {
                return this.dataFactory.getOWLDataExactCardinality(cardinality, prop);
            }
        } else if ("" != null) {
            return this.dataFactory.getOWLDataExactCardinality(cardinality, prop, rng);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassExpression DataMaxCardinality() throws ParseException {
        int cardinality = 0;
        OWLDataPropertyExpression prop = null;
        OWLDataRange rng = null;
        this.jj_consume_token(61);
        this.jj_consume_token(12);
        cardinality = this.Cardinality();
        prop = this.DataPropertyExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 38: 
            case 39: 
            case 40: 
            case 46: 
            case 47: 
            case 120: 
            case 123: {
                rng = this.DataRange();
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        this.jj_consume_token(13);
        if (rng == null) {
            if ("" != null) {
                return this.dataFactory.getOWLDataMaxCardinality(cardinality, prop);
            }
        } else if ("" != null) {
            return this.dataFactory.getOWLDataMaxCardinality(cardinality, prop, rng);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClass Class() throws ParseException {
        this.jj_consume_token(33);
        this.jj_consume_token(12);
        OWLClass cls = this.ClassIRI();
        this.jj_consume_token(13);
        if ("" != null) {
            return cls;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLObjectPropertyExpression ObjectPropertyExpression() throws ParseException {
        OWLObjectPropertyExpression prop;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 44: {
                prop = this.InverseObjectProperty();
                break;
            }
            case 120: 
            case 123: {
                prop = this.ObjectPropertyIRI();
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return prop;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLObjectPropertyExpression InverseObjectProperty() throws ParseException {
        this.jj_consume_token(44);
        this.jj_consume_token(12);
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLObjectInverseOf(prop);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLObjectProperty ObjectProperty() throws ParseException {
        this.jj_consume_token(34);
        this.jj_consume_token(12);
        OWLObjectProperty prop = this.ObjectPropertyIRI();
        this.jj_consume_token(13);
        if ("" != null) {
            return prop;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLDataPropertyExpression DataPropertyExpression() throws ParseException {
        OWLDataProperty prop = this.DataPropertyIRI();
        if ("" != null) {
            return prop;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLDataProperty DataPropertyIRI() throws ParseException {
        IRI iri = this.IRI();
        if ("" != null) {
            return this.dataFactory.getOWLDataProperty(iri);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLDataProperty DataProperty() throws ParseException {
        this.jj_consume_token(35);
        this.jj_consume_token(12);
        OWLDataProperty prop = this.DataPropertyIRI();
        this.jj_consume_token(13);
        if ("" != null) {
            return prop;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLAnnotationProperty AnnotationProperty() throws ParseException {
        this.jj_consume_token(25);
        this.jj_consume_token(12);
        OWLAnnotationProperty prop = this.AnnotationPropertyIRI();
        this.jj_consume_token(13);
        if ("" != null) {
            return prop;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLAnnotationProperty AnnotationPropertyIRI() throws ParseException {
        IRI iri = this.IRI();
        if ("" != null) {
            return this.dataFactory.getOWLAnnotationProperty(iri);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLNamedIndividual NamedIndividual() throws ParseException {
        this.jj_consume_token(36);
        this.jj_consume_token(12);
        OWLNamedIndividual ind = this.IndividualIRI();
        this.jj_consume_token(13);
        if ("" != null) {
            return ind;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLAnonymousIndividual AnonymousIndividual() throws ParseException {
        Token t = this.jj_consume_token(128);
        String id = t.image.substring(2, t.image.length());
        if ("" != null) {
            return this.dataFactory.getOWLAnonymousIndividual(id);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLDatatype Datatype() throws ParseException {
        this.jj_consume_token(37);
        this.jj_consume_token(12);
        OWLDatatype dt = this.DatatypeIRI();
        this.jj_consume_token(13);
        if ("" != null) {
            return dt;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLDatatype DatatypeIRI() throws ParseException {
        IRI iri = this.IRI();
        if ("" != null) {
            return this.dataFactory.getOWLDatatype(iri);
        }
        throw new Error("Missing return statement in function");
    }

    public final int Cardinality() throws ParseException {
        int card = 0;
        card = this.Integer();
        if ("" != null) {
            return card;
        }
        throw new Error("Missing return statement in function");
    }

    public final int Integer() throws ParseException {
        Token t = this.jj_consume_token(119);
        int i = Integer.parseInt(t.image);
        if ("" != null) {
            return i;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLDatatypeDefinitionAxiom DatatypeDefinitionAxiom() throws ParseException {
        this.jj_consume_token(48);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axAnnos = this.AxiomAnnotationSet();
        OWLDatatype datatype = this.DatatypeIRI();
        OWLDataRange dr = this.DataRange();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLDatatypeDefinitionAxiom(datatype, dr, axAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLDataRange DataRange() throws ParseException {
        OWLDatatype rng;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 120: 
            case 123: {
                rng = this.DatatypeIRI();
                break;
            }
            case 38: {
                rng = this.DataOneOf();
                break;
            }
            case 46: {
                rng = this.DataComplementOf();
                break;
            }
            case 47: {
                rng = this.DataRangeRestriction();
                break;
            }
            case 40: {
                rng = this.DataIntersectionOf();
                break;
            }
            case 39: {
                rng = this.DataUnionOf();
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return rng;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLDataRange DataComplementOf() throws ParseException {
        this.jj_consume_token(46);
        this.jj_consume_token(12);
        OWLDataRange rng = this.DataRange();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLDataComplementOf(rng);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLDataRange DataOneOf() throws ParseException {
        HashSet<OWLLiteral> values = new HashSet<OWLLiteral>();
        OWLLiteral con = null;
        Object rng = null;
        this.jj_consume_token(38);
        this.jj_consume_token(12);
        block3: while (true) {
            con = this.Literal();
            values.add(con);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 11: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[18] = this.jj_gen;
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLDataOneOf(values);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLDataRange DataUnionOf() throws ParseException {
        HashSet<OWLDataRange> ranges = new HashSet<OWLDataRange>();
        this.jj_consume_token(39);
        this.jj_consume_token(12);
        block3: while (true) {
            OWLDataRange dataRange = this.DataRange();
            ranges.add(dataRange);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 38: 
                case 39: 
                case 40: 
                case 46: 
                case 47: 
                case 120: 
                case 123: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[19] = this.jj_gen;
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLDataUnionOf(ranges);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLDataRange DataIntersectionOf() throws ParseException {
        HashSet<OWLDataRange> ranges = new HashSet<OWLDataRange>();
        this.jj_consume_token(40);
        this.jj_consume_token(12);
        block3: while (true) {
            OWLDataRange dataRange = this.DataRange();
            ranges.add(dataRange);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 38: 
                case 39: 
                case 40: 
                case 46: 
                case 47: 
                case 120: 
                case 123: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[20] = this.jj_gen;
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLDataIntersectionOf(ranges);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLDataRange DataRangeRestriction() throws ParseException {
        HashSet<OWLFacetRestriction> facetRestrictions = new HashSet<OWLFacetRestriction>();
        this.jj_consume_token(47);
        this.jj_consume_token(12);
        OWLDatatype rng = this.DatatypeIRI();
        block3: while (true) {
            OWLFacetRestriction facetRestriction = this.DataRangeFacetRestriction();
            facetRestrictions.add(facetRestriction);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 120: 
                case 123: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[21] = this.jj_gen;
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLDatatypeRestriction(rng, facetRestrictions);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLFacetRestriction DataRangeFacetRestriction() throws ParseException {
        IRI iri = this.IRI();
        OWLLiteral con = this.Literal();
        OWLFacet v = OWLFacet.getFacetByShortName((String)iri.getFragment());
        if ("" != null) {
            return this.dataFactory.getOWLFacetRestriction(v, con);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLAxiom Axiom() throws ParseException {
        OWLClassAxiom ax = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                ax = this.ClassAxiom();
                break;
            }
            case 45: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                ax = this.ObjectPropertyAxiom();
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                ax = this.DataPropertyAxiom();
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                ax = this.IndividualAxiom();
                break;
            }
            case 31: {
                ax = this.Declaration();
                break;
            }
            case 30: {
                ax = this.HasKey();
                break;
            }
            case 48: {
                ax = this.DatatypeDefinitionAxiom();
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                ax = this.AnnotationAxiom();
                break;
            }
            case 100: {
                ax = this.DLSafeRule();
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return ax;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassAxiom ClassAxiom() throws ParseException {
        OWLClassAxiom ax;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 18: {
                ax = this.SubClassOf();
                break;
            }
            case 21: {
                ax = this.EquivalentClasses();
                break;
            }
            case 22: {
                ax = this.DisjointClasses();
                break;
            }
            case 23: {
                ax = this.DisjointUnion();
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return ax;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassAxiom SubClassOf() throws ParseException {
        this.jj_consume_token(18);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLClassExpression subClass = this.ClassExpression();
        OWLClassExpression superClass = this.ClassExpression();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLSubClassOfAxiom(subClass, superClass, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassAxiom EquivalentClasses() throws ParseException {
        this.jj_consume_token(21);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        Set<OWLClassExpression> classExpressions = this.ClassExpressionSet();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLEquivalentClassesAxiom(classExpressions, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassAxiom DisjointClasses() throws ParseException {
        this.jj_consume_token(22);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        Set<OWLClassExpression> classExpressions = this.ClassExpressionSet();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLDisjointClassesAxiom(classExpressions, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLClassAxiom DisjointUnion() throws ParseException {
        this.jj_consume_token(23);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLClass cls = this.ClassIRI();
        Set<OWLClassExpression> classExpressions = this.ClassExpressionSet();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLDisjointUnionAxiom(cls, classExpressions, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLPropertyAxiom ObjectPropertyAxiom() throws ParseException {
        OWLPropertyAxiom ax;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 64: {
                ax = this.SubObjectPropertyOf();
                break;
            }
            case 65: {
                ax = this.EquivalentObjectProperties();
                break;
            }
            case 66: {
                ax = this.DisjointObjectProperties();
                break;
            }
            case 68: {
                ax = this.ObjectPropertyRange();
                break;
            }
            case 67: {
                ax = this.ObjectPropertyDomain();
                break;
            }
            case 69: {
                ax = this.FunctionalObjectProperty();
                break;
            }
            case 70: {
                ax = this.InverseFunctionalObjectProperty();
                break;
            }
            case 73: {
                ax = this.SymmetricObjectProperty();
                break;
            }
            case 74: {
                ax = this.AsymmetricObjectProperty();
                break;
            }
            case 71: {
                ax = this.ReflexiveObjectProperty();
                break;
            }
            case 72: {
                ax = this.IrreflexiveObjectProperty();
                break;
            }
            case 75: {
                ax = this.TransitiveObjectProperty();
                break;
            }
            case 45: {
                ax = this.InverseObjectProperties();
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return ax;
        }
        throw new Error("Missing return statement in function");
    }

    public final List<OWLObjectPropertyExpression> SubObjectPropertyChain() throws ParseException {
        ArrayList<OWLObjectPropertyExpression> props = new ArrayList<OWLObjectPropertyExpression>();
        this.jj_consume_token(63);
        this.jj_consume_token(12);
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        props.add(prop);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 44: 
                case 120: 
                case 123: {
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                    break block3;
                }
            }
            prop = this.ObjectPropertyExpression();
            props.add(prop);
        }
        this.jj_consume_token(13);
        if ("" != null) {
            return props;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLPropertyAxiom SubObjectPropertyOf() throws ParseException {
        OWLObjectPropertyExpression subProperty = null;
        List<OWLObjectPropertyExpression> chain = null;
        OWLObjectPropertyExpression superProperty = null;
        this.jj_consume_token(64);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 44: 
            case 120: 
            case 123: {
                subProperty = this.ObjectPropertyExpression();
                break;
            }
            case 63: {
                chain = this.SubObjectPropertyChain();
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        superProperty = this.ObjectPropertyExpression();
        this.jj_consume_token(13);
        if (subProperty != null) {
            if ("" != null) {
                return this.dataFactory.getOWLSubObjectPropertyOfAxiom(subProperty, superProperty, axiomAnnos);
            }
        } else if (chain != null) {
            if ("" != null) {
                return this.dataFactory.getOWLSubPropertyChainOfAxiom(chain, superProperty, axiomAnnos);
            }
        } else if ("" != null) {
            return null;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLPropertyAxiom EquivalentObjectProperties() throws ParseException {
        this.jj_consume_token(65);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        Set<OWLObjectPropertyExpression> props = this.ObjectPropertySet();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLEquivalentObjectPropertiesAxiom(props, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLPropertyAxiom DisjointObjectProperties() throws ParseException {
        this.jj_consume_token(66);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        Set<OWLObjectPropertyExpression> props = this.ObjectPropertySet();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLDisjointObjectPropertiesAxiom(props, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final Set<OWLObjectPropertyExpression> ObjectPropertySet() throws ParseException {
        HashSet<OWLObjectPropertyExpression> props = new HashSet<OWLObjectPropertyExpression>();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        props.add(prop);
        prop = this.ObjectPropertyExpression();
        props.add(prop);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 44: 
                case 120: 
                case 123: {
                    break;
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                    break block3;
                }
            }
            prop = this.ObjectPropertyExpression();
            props.add(prop);
        }
        if ("" != null) {
            return props;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLPropertyAxiom ObjectPropertyRange() throws ParseException {
        this.jj_consume_token(68);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        OWLClassExpression range = this.ClassExpression();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLObjectPropertyRangeAxiom(prop, range, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLPropertyAxiom ObjectPropertyDomain() throws ParseException {
        this.jj_consume_token(67);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        OWLClassExpression desc = this.ClassExpression();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLObjectPropertyDomainAxiom(prop, desc, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLPropertyAxiom FunctionalObjectProperty() throws ParseException {
        Set<Object> axiomAnnos = Collections.emptySet();
        this.jj_consume_token(69);
        this.jj_consume_token(12);
        axiomAnnos = this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLFunctionalObjectPropertyAxiom(prop, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLPropertyAxiom InverseObjectProperties() throws ParseException {
        this.jj_consume_token(45);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLObjectPropertyExpression propA = this.ObjectPropertyExpression();
        OWLObjectPropertyExpression propB = this.ObjectPropertyExpression();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLInverseObjectPropertiesAxiom(propA, propB, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLPropertyAxiom InverseFunctionalObjectProperty() throws ParseException {
        this.jj_consume_token(70);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(prop, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLPropertyAxiom SymmetricObjectProperty() throws ParseException {
        this.jj_consume_token(73);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLSymmetricObjectPropertyAxiom(prop, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLPropertyAxiom AsymmetricObjectProperty() throws ParseException {
        this.jj_consume_token(74);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLAsymmetricObjectPropertyAxiom(prop, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLPropertyAxiom ReflexiveObjectProperty() throws ParseException {
        this.jj_consume_token(71);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLReflexiveObjectPropertyAxiom(prop, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLPropertyAxiom IrreflexiveObjectProperty() throws ParseException {
        this.jj_consume_token(72);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLIrreflexiveObjectPropertyAxiom(prop, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLPropertyAxiom TransitiveObjectProperty() throws ParseException {
        this.jj_consume_token(75);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLTransitiveObjectPropertyAxiom(prop, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLPropertyAxiom DataPropertyAxiom() throws ParseException {
        OWLPropertyAxiom ax;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 76: {
                ax = this.SubDataPropertyOf();
                break;
            }
            case 77: {
                ax = this.EquivalentDataProperties();
                break;
            }
            case 78: {
                ax = this.DisjointDataProperties();
                break;
            }
            case 80: {
                ax = this.DataPropertyRange();
                break;
            }
            case 79: {
                ax = this.DataPropertyDomain();
                break;
            }
            case 81: {
                ax = this.FunctionalDataProperty();
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return ax;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLPropertyAxiom SubDataPropertyOf() throws ParseException {
        this.jj_consume_token(76);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLDataPropertyExpression subProperty = this.DataPropertyExpression();
        OWLDataPropertyExpression superProperty = this.DataPropertyExpression();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLSubDataPropertyOfAxiom(subProperty, superProperty, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLPropertyAxiom EquivalentDataProperties() throws ParseException {
        this.jj_consume_token(77);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        Set<OWLDataPropertyExpression> props = this.DataPropertySet();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLEquivalentDataPropertiesAxiom(props, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLPropertyAxiom DisjointDataProperties() throws ParseException {
        this.jj_consume_token(78);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        Set<OWLDataPropertyExpression> props = this.DataPropertySet();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLDisjointDataPropertiesAxiom(props, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final Set<OWLDataPropertyExpression> DataPropertySet() throws ParseException {
        HashSet<OWLDataPropertyExpression> props = new HashSet<OWLDataPropertyExpression>();
        OWLDataPropertyExpression prop = this.DataPropertyExpression();
        props.add(prop);
        prop = this.DataPropertyExpression();
        props.add(prop);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 120: 
                case 123: {
                    break;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                    break block3;
                }
            }
            prop = this.DataPropertyExpression();
            props.add(prop);
        }
        if ("" != null) {
            return props;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLPropertyAxiom DataPropertyDomain() throws ParseException {
        this.jj_consume_token(79);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLDataPropertyExpression prop = this.DataPropertyExpression();
        OWLClassExpression domain = this.ClassExpression();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLDataPropertyDomainAxiom(prop, domain, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLPropertyAxiom DataPropertyRange() throws ParseException {
        this.jj_consume_token(80);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLDataPropertyExpression prop = this.DataPropertyExpression();
        OWLDataRange rng = this.DataRange();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLDataPropertyRangeAxiom(prop, rng, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLPropertyAxiom FunctionalDataProperty() throws ParseException {
        this.jj_consume_token(81);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLDataPropertyExpression prop = this.DataPropertyExpression();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLFunctionalDataPropertyAxiom(prop, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLIndividualAxiom IndividualAxiom() throws ParseException {
        OWLIndividualAxiom ax;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 82: {
                ax = this.SameIndividuals();
                break;
            }
            case 83: {
                ax = this.DifferentIndividuals();
                break;
            }
            case 84: {
                ax = this.ClassAssertion();
                break;
            }
            case 85: {
                ax = this.ObjectPropertyAssertion();
                break;
            }
            case 87: {
                ax = this.DataPropertyAssertion();
                break;
            }
            case 86: {
                ax = this.NegativeObjectPropertyAssertion();
                break;
            }
            case 88: {
                ax = this.NegativeDataPropertyAssertion();
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return ax;
        }
        throw new Error("Missing return statement in function");
    }

    public final Set<OWLIndividual> IndividualSet() throws ParseException {
        HashSet<OWLIndividual> individuals = new HashSet<OWLIndividual>();
        OWLIndividual ind = this.Individual();
        individuals.add(ind);
        ind = this.Individual();
        individuals.add(ind);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 120: 
                case 123: 
                case 128: {
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    break block3;
                }
            }
            ind = this.Individual();
            individuals.add(ind);
        }
        if ("" != null) {
            return individuals;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLIndividualAxiom SameIndividuals() throws ParseException {
        this.jj_consume_token(82);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        Set<OWLIndividual> individuals = this.IndividualSet();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLSameIndividualAxiom(individuals, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLIndividualAxiom DifferentIndividuals() throws ParseException {
        this.jj_consume_token(83);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        Set<OWLIndividual> individuals = this.IndividualSet();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLDifferentIndividualsAxiom(individuals, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLIndividualAxiom ClassAssertion() throws ParseException {
        this.jj_consume_token(84);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLClassExpression desc = this.ClassExpression();
        OWLIndividual ind = this.Individual();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLClassAssertionAxiom(desc, ind, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLIndividualAxiom ObjectPropertyAssertion() throws ParseException {
        this.jj_consume_token(85);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        OWLIndividual subj = this.Individual();
        OWLIndividual obj = this.Individual();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLObjectPropertyAssertionAxiom(prop, subj, obj, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLIndividualAxiom NegativeObjectPropertyAssertion() throws ParseException {
        this.jj_consume_token(86);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        OWLIndividual subj = this.Individual();
        OWLIndividual obj = this.Individual();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLNegativeObjectPropertyAssertionAxiom(prop, subj, obj, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLIndividualAxiom DataPropertyAssertion() throws ParseException {
        this.jj_consume_token(87);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLDataPropertyExpression prop = this.DataPropertyExpression();
        OWLIndividual subj = this.Individual();
        OWLLiteral obj = this.Literal();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLDataPropertyAssertionAxiom(prop, subj, obj, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLIndividualAxiom NegativeDataPropertyAssertion() throws ParseException {
        this.jj_consume_token(88);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLDataPropertyExpression prop = this.DataPropertyExpression();
        OWLIndividual subj = this.Individual();
        OWLLiteral obj = this.Literal();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLNegativeDataPropertyAssertionAxiom(prop, subj, obj, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLNamedIndividual IndividualIRI() throws ParseException {
        IRI iri = this.IRI();
        if ("" != null) {
            return this.dataFactory.getOWLNamedIndividual(iri);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLIndividual Individual() throws ParseException {
        OWLNamedIndividual ind;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 120: 
            case 123: {
                ind = this.IndividualIRI();
                break;
            }
            case 128: {
                ind = this.AnonymousIndividual();
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return ind;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLObjectProperty ObjectPropertyIRI() throws ParseException {
        IRI iri = this.IRI();
        if ("" != null) {
            return this.dataFactory.getOWLObjectProperty(iri);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLAxiom AnnotationAxiom() throws ParseException {
        OWLAnnotationAssertionAxiom axiom;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 26: {
                axiom = this.AnnotationAssertion();
                break;
            }
            case 28: {
                axiom = this.AnnotationPropertyDomain();
                break;
            }
            case 29: {
                axiom = this.AnnotationPropertyRange();
                break;
            }
            case 27: {
                axiom = this.SubAnnotationPropertyOf();
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return axiom;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLAnnotation Annotation() throws ParseException {
        HashSet<OWLAnnotation> annos = null;
        OWLAnnotation anno = null;
        this.jj_consume_token(24);
        annos = new HashSet<OWLAnnotation>();
        this.jj_consume_token(12);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                    break block3;
                }
            }
            anno = this.Annotation();
            annos.add(anno);
        }
        OWLAnnotationProperty prop = this.AnnotationPropertyIRI();
        OWLAnnotationValue val = this.AnnotationValue();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLAnnotation(prop, val, annos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLAnnotationSubject AnnotationSubject() throws ParseException {
        IRI subj;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 120: 
            case 123: {
                subj = this.IRI();
                break;
            }
            case 128: {
                subj = this.AnonymousIndividual();
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return subj;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLAnnotationValue AnnotationValue() throws ParseException {
        IRI value;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 120: 
            case 123: {
                value = this.IRI();
                break;
            }
            case 128: {
                value = this.AnonymousIndividual();
                break;
            }
            case 11: {
                value = this.Literal();
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return value;
        }
        throw new Error("Missing return statement in function");
    }

    public final Set<OWLAnnotation> AxiomAnnotationSet() throws ParseException {
        HashSet<OWLAnnotation> annos = null;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                    break block3;
                }
            }
            OWLAnnotation anno = this.Annotation();
            if (annos == null) {
                annos = new HashSet<OWLAnnotation>();
            }
            annos.add(anno);
        }
        if (annos == null) {
            annos = Collections.emptySet();
        }
        if ("" != null) {
            return annos;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLImportsDeclaration ImportsDeclaration() throws ParseException {
        this.jj_consume_token(16);
        this.jj_consume_token(12);
        IRI iri = this.IRI();
        this.jj_consume_token(13);
        OWLImportsDeclaration importsDeclaration = this.dataFactory.getOWLImportsDeclaration(iri);
        if ("" != null) {
            return importsDeclaration;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLAnnotationAssertionAxiom AnnotationAssertion() throws ParseException {
        this.jj_consume_token(26);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLAnnotationProperty prop = this.AnnotationPropertyIRI();
        OWLAnnotationSubject subj = this.AnnotationSubject();
        OWLAnnotationValue val = this.AnnotationValue();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLAnnotationAssertionAxiom(prop, subj, val, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLSubAnnotationPropertyOfAxiom SubAnnotationPropertyOf() throws ParseException {
        this.jj_consume_token(27);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLAnnotationProperty subProp = this.AnnotationPropertyIRI();
        OWLAnnotationProperty superProperty = this.AnnotationPropertyIRI();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLSubAnnotationPropertyOfAxiom(subProp, superProperty, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLAnnotationPropertyDomainAxiom AnnotationPropertyDomain() throws ParseException {
        this.jj_consume_token(28);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLAnnotationProperty prop = this.AnnotationPropertyIRI();
        IRI domain = this.IRI();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLAnnotationPropertyDomainAxiom(prop, domain, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLAnnotationPropertyRangeAxiom AnnotationPropertyRange() throws ParseException {
        this.jj_consume_token(29);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLAnnotationProperty prop = this.AnnotationPropertyIRI();
        IRI range = this.IRI();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLAnnotationPropertyRangeAxiom(prop, range, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLHasKeyAxiom HasKey() throws ParseException {
        OWLObjectPropertyExpression prop;
        HashSet<OWLObjectPropertyExpression> props = new HashSet<OWLObjectPropertyExpression>();
        this.jj_consume_token(30);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        OWLClassExpression ce = this.ClassExpression();
        this.jj_consume_token(12);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 44: 
                case 120: 
                case 123: {
                    break;
                }
                default: {
                    this.jj_la1[38] = this.jj_gen;
                    break block6;
                }
            }
            prop = this.ObjectPropertyExpression();
            props.add(prop);
        }
        this.jj_consume_token(13);
        this.jj_consume_token(12);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 120: 
                case 123: {
                    break;
                }
                default: {
                    this.jj_la1[39] = this.jj_gen;
                    break block7;
                }
            }
            prop = this.DataPropertyExpression();
            props.add(prop);
        }
        this.jj_consume_token(13);
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getOWLHasKeyAxiom(ce, props, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLAxiom Declaration() throws ParseException {
        OWLEntity entity = null;
        Object iri = null;
        Object con = null;
        this.jj_consume_token(31);
        this.jj_consume_token(12);
        Set<OWLAnnotation> axiomAnnos = this.AxiomAnnotationSet();
        entity = this.Entity();
        this.jj_consume_token(13);
        if (this.ignoreAnnotationsAndDeclarations) {
            if ("" != null) {
                return null;
            }
        } else if ("" != null) {
            return this.dataFactory.getOWLDeclarationAxiom(entity, axiomAnnos);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLEntity Entity() throws ParseException {
        OWLClass entity;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 33: {
                entity = this.Class();
                break;
            }
            case 34: {
                entity = this.ObjectProperty();
                break;
            }
            case 35: {
                entity = this.DataProperty();
                break;
            }
            case 36: {
                entity = this.NamedIndividual();
                break;
            }
            case 37: {
                entity = this.Datatype();
                break;
            }
            case 25: {
                entity = this.AnnotationProperty();
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return entity;
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLLiteral Literal() throws ParseException {
        boolean plain = true;
        OWLDatatype datatype = null;
        String lang = "";
        String literal = this.QuotedString();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 19: 
            case 20: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 20: {
                        this.jj_consume_token(20);
                        plain = false;
                        datatype = this.DatatypeIRI();
                        break block0;
                    }
                    case 19: {
                        this.jj_consume_token(19);
                        lang = this.LangTag();
                        break block0;
                    }
                }
                this.jj_la1[41] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
            }
        }
        if (plain) {
            if ("" != null) {
                return this.dataFactory.getOWLLiteral(literal, lang);
            }
        } else {
            if (datatype.isFloat() && (literal.endsWith("f") || literal.endsWith("F")) && !literal.endsWith("inf") && !literal.endsWith("INF")) {
                literal = literal.substring(0, literal.length() - 1);
            }
            if ("" != null) {
                return this.dataFactory.getOWLLiteral(literal, datatype);
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final String QuotedString() throws ParseException {
        Token t = this.jj_consume_token(11);
        String raw = t.image.substring(1, t.image.length() - 1);
        if ("" != null) {
            return EscapeUtils.unescapeString((String)raw);
        }
        throw new Error("Missing return statement in function");
    }

    public final String LangTag() throws ParseException {
        String lang = "";
        Token t = this.jj_consume_token(122);
        lang = lang + t.image;
        if ("" != null) {
            return lang;
        }
        throw new Error("Missing return statement in function");
    }

    public final SWRLRule DLSafeRule() throws ParseException {
        SWRLAtom atom;
        this.jj_consume_token(100);
        this.jj_consume_token(12);
        Set<OWLAnnotation> annos = this.AxiomAnnotationSet();
        this.jj_consume_token(101);
        HashSet<SWRLAtom> body = new HashSet<SWRLAtom>();
        this.jj_consume_token(12);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: {
                    break;
                }
                default: {
                    this.jj_la1[43] = this.jj_gen;
                    break block6;
                }
            }
            atom = this.Atom();
            body.add(atom);
        }
        this.jj_consume_token(13);
        this.jj_consume_token(102);
        HashSet<SWRLAtom> head = new HashSet<SWRLAtom>();
        this.jj_consume_token(12);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: {
                    break;
                }
                default: {
                    this.jj_la1[44] = this.jj_gen;
                    break block7;
                }
            }
            atom = this.Atom();
            head.add(atom);
        }
        this.jj_consume_token(13);
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getSWRLRule(body, head, annos);
        }
        throw new Error("Missing return statement in function");
    }

    public final SWRLAtom Atom() throws ParseException {
        SWRLClassAtom atom;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 103: {
                atom = this.ClassAtom();
                break;
            }
            case 104: {
                atom = this.DataRangeAtom();
                break;
            }
            case 105: {
                atom = this.ObjectPropertyAtom();
                break;
            }
            case 106: {
                atom = this.DataPropertyAtom();
                break;
            }
            case 107: {
                atom = this.BuiltInAtom();
                break;
            }
            case 108: {
                atom = this.SameIndividualAtom();
                break;
            }
            case 109: {
                atom = this.DifferentIndividualsAtom();
                break;
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return atom;
        }
        throw new Error("Missing return statement in function");
    }

    public final SWRLClassAtom ClassAtom() throws ParseException {
        this.jj_consume_token(103);
        this.jj_consume_token(12);
        OWLClassExpression ce = this.ClassExpression();
        SWRLIArgument arg0 = this.IArg();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getSWRLClassAtom(ce, arg0);
        }
        throw new Error("Missing return statement in function");
    }

    public final SWRLDataRangeAtom DataRangeAtom() throws ParseException {
        this.jj_consume_token(104);
        this.jj_consume_token(12);
        OWLDataRange rng = this.DataRange();
        SWRLDArgument arg0 = this.DArg();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getSWRLDataRangeAtom(rng, arg0);
        }
        throw new Error("Missing return statement in function");
    }

    public final SWRLObjectPropertyAtom ObjectPropertyAtom() throws ParseException {
        this.jj_consume_token(105);
        this.jj_consume_token(12);
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        SWRLIArgument arg0 = this.IArg();
        SWRLIArgument arg1 = this.IArg();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getSWRLObjectPropertyAtom(prop, arg0, arg1);
        }
        throw new Error("Missing return statement in function");
    }

    public final SWRLDataPropertyAtom DataPropertyAtom() throws ParseException {
        this.jj_consume_token(106);
        this.jj_consume_token(12);
        OWLDataProperty prop = this.DataPropertyIRI();
        SWRLIArgument arg0 = this.IArg();
        SWRLDArgument arg1 = this.DArg();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getSWRLDataPropertyAtom((OWLDataPropertyExpression)prop, arg0, arg1);
        }
        throw new Error("Missing return statement in function");
    }

    public final SWRLBuiltInAtom BuiltInAtom() throws ParseException {
        this.jj_consume_token(107);
        this.jj_consume_token(12);
        ArrayList<SWRLDArgument> args = new ArrayList<SWRLDArgument>();
        IRI iri = this.IRI();
        SWRLDArgument arg = this.DArg();
        args.add(arg);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 11: 
                case 110: {
                    break;
                }
                default: {
                    this.jj_la1[46] = this.jj_gen;
                    break block3;
                }
            }
            arg = this.DArg();
            args.add(arg);
        }
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getSWRLBuiltInAtom(iri, args);
        }
        throw new Error("Missing return statement in function");
    }

    public final SWRLSameIndividualAtom SameIndividualAtom() throws ParseException {
        this.jj_consume_token(108);
        this.jj_consume_token(12);
        SWRLIArgument arg0 = this.IArg();
        SWRLIArgument arg1 = this.IArg();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getSWRLSameIndividualAtom(arg0, arg1);
        }
        throw new Error("Missing return statement in function");
    }

    public final SWRLDifferentIndividualsAtom DifferentIndividualsAtom() throws ParseException {
        this.jj_consume_token(109);
        this.jj_consume_token(12);
        SWRLIArgument arg0 = this.IArg();
        SWRLIArgument arg1 = this.IArg();
        this.jj_consume_token(13);
        if ("" != null) {
            return this.dataFactory.getSWRLDifferentIndividualsAtom(arg0, arg1);
        }
        throw new Error("Missing return statement in function");
    }

    public final SWRLIArgument IArg() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 110: {
                this.jj_consume_token(110);
                this.jj_consume_token(12);
                IRI iri = this.IRI();
                this.jj_consume_token(13);
                if ("" == null) break;
                return this.dataFactory.getSWRLVariable(iri);
            }
            case 120: 
            case 123: {
                OWLNamedIndividual ind = this.IndividualIRI();
                if ("" == null) break;
                return this.dataFactory.getSWRLIndividualArgument((OWLIndividual)ind);
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final SWRLDArgument DArg() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 110: {
                this.jj_consume_token(110);
                this.jj_consume_token(12);
                IRI iri = this.IRI();
                this.jj_consume_token(13);
                if ("" == null) break;
                return this.dataFactory.getSWRLVariable(iri);
            }
            case 11: {
                OWLLiteral literal = this.Literal();
                if ("" == null) break;
                return this.dataFactory.getSWRLLiteralArgument(literal);
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0, 0, 0x1010000, 0x1010000, -52166656, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 0, 0, 0, -52166656, 0xE40000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x3C000000, 0x1000000, 0, 2048, 0x1000000, 0, 0, 0x2000000, 0x180000, 0x180000, 0, 0, 0, 2048, 0, 2048};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 73728, 0, 2147356160, 2147356160, 0, 2147356160, 2147356160, 2147356160, 49600, 49600, 49600, 4096, 49600, 0, 49600, 49600, 0, 73728, 0, 8192, 4096, -2147479552, 4096, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4096, 0, 62, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0x2000000, 0, 0, 0, 0, 0x1FFFFFF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1FFFFFF, 0, 4095, 0, 0, 0, 258048, 0, 33292288, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0x9000000, 0x9000000, 0, 0, 16, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0, 0x9000000, 0x9000000, 0x9000000, 16, 0, 0, 0x9000000, 0x9000000, 0x9000000, 0, 0x9000000, 0, 0x9000000, 0x9000000, 0, 0, 0x9000000, 0x9000000, 0, 0x9000000, 0x9000000, 0, 0, 0, 16256, 16256, 16256, 16384, 0x9004000, 16384};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public OWLFunctionalSyntaxParser(TokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 49; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(TokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 49; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[130];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 49; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) == 0) continue;
                la1tokens[128 + j] = true;
            }
        }
        for (i = 0; i < 130; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        OWLFunctionalSyntaxParser.jj_la1_init_0();
        OWLFunctionalSyntaxParser.jj_la1_init_1();
        OWLFunctionalSyntaxParser.jj_la1_init_2();
        OWLFunctionalSyntaxParser.jj_la1_init_3();
        OWLFunctionalSyntaxParser.jj_la1_init_4();
    }
}

