/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.elasticsearch.hadoop.serialization.dto.Node;
import org.elasticsearch.hadoop.serialization.dto.Shard;
import org.elasticsearch.hadoop.util.Assert;

abstract class ShardSorter {
    ShardSorter() {
    }

    public static Map<Shard, Node> find(List<List<Map<String, Object>>> targetShards, Map<String, Node> httpNodes, Log log) {
        LinkedHashMap<Node, Set<Shard>> shardsPerNode = new LinkedHashMap<Node, Set<Shard>>();
        LinkedHashMap<SimpleShard, LinkedHashSet<Node>> nodesForShard = new LinkedHashMap<SimpleShard, LinkedHashSet<Node>>();
        for (List<Map<String, Object>> shardGroup : targetShards) {
            for (Map<String, Object> shardData : shardGroup) {
                Shard shard = new Shard(shardData);
                Node node = httpNodes.get(shard.getNode());
                if (node == null) {
                    log.warn((Object)String.format("Cannot find node with id [%s] (is HTTP enabled?) from shard [%s] in nodes [%s]; layout [%s]", shard.getNode(), shard, httpNodes, targetShards));
                    return Collections.emptyMap();
                }
                LinkedHashSet<Shard> shardSet = (LinkedHashSet<Shard>)shardsPerNode.get(node);
                if (shardSet == null) {
                    shardSet = new LinkedHashSet<Shard>();
                    shardsPerNode.put(node, shardSet);
                }
                shardSet.add(shard);
                SimpleShard ss = SimpleShard.from(shard);
                LinkedHashSet<Node> nodeSet = (LinkedHashSet<Node>)nodesForShard.get(ss);
                if (nodeSet == null) {
                    nodeSet = new LinkedHashSet<Node>();
                    nodesForShard.put(ss, nodeSet);
                }
                nodeSet.add(node);
            }
        }
        return ShardSorter.checkCombo(httpNodes.values(), shardsPerNode, targetShards.size());
    }

    private static Map<Shard, Node> checkCombo(Collection<Node> nodes, Map<Node, Set<Shard>> shardsPerNode, int numberOfShards) {
        Iterator<Set<Node>> nodesCombinations = ShardSorter.powerList(new LinkedHashSet<Node>(nodes));
        LinkedHashSet<SimpleShard> shards = new LinkedHashSet<SimpleShard>();
        boolean overlappingShards = false;
        while (nodesCombinations.hasNext()) {
            Set<Node> set = nodesCombinations.next();
            shards.clear();
            overlappingShards = false;
            for (Node node : set) {
                Set<Shard> associatedShards = shardsPerNode.get(node);
                if (associatedShards == null) continue;
                for (Shard shard : associatedShards) {
                    if (shards.add(SimpleShard.from(shard))) continue;
                    overlappingShards = true;
                    break;
                }
                if (!overlappingShards) continue;
                break;
            }
            if (overlappingShards || shards.size() != numberOfShards) continue;
            LinkedHashMap<Shard, Node> finalShards = new LinkedHashMap<Shard, Node>();
            for (Node node : set) {
                Set<Shard> associatedShards = shardsPerNode.get(node);
                if (associatedShards == null) continue;
                HashSet<Integer> shardIds = new HashSet<Integer>();
                for (Shard potentialShard : associatedShards) {
                    if (!shardIds.add(potentialShard.getName())) continue;
                    finalShards.put(potentialShard, node);
                }
            }
            return finalShards;
        }
        return Collections.emptyMap();
    }

    static <E> Iterator<Set<E>> powerList(Set<E> set) {
        return new PowerSet<E>(set).iterator();
    }

    private static abstract class ReverseIndexedListIterator<E>
    implements Iterator<E> {
        private final int size;
        private int position;

        protected ReverseIndexedListIterator(int size) {
            this.size = size;
            this.position = size - 1;
        }

        @Override
        public final boolean hasNext() {
            return this.position > 0;
        }

        @Override
        public final E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.get(this.position--);
        }

        public final int nextIndex() {
            return this.position;
        }

        public final boolean hasPrevious() {
            return this.position < this.size;
        }

        public final E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.get(++this.position);
        }

        public final int previousIndex() {
            return this.position + 1;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        protected abstract E get(int var1);
    }

    private static final class SubSet<E>
    extends AbstractSet<E> {
        private final Map<E, Integer> inputSet;
        private final int mask;

        SubSet(Map<E, Integer> inputSet, int mask) {
            this.inputSet = inputSet;
            this.mask = mask;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                final List<E> elements;
                int remainingSetBits;
                {
                    this.elements = new ArrayList(SubSet.this.inputSet.keySet());
                    this.remainingSetBits = SubSet.this.mask;
                }

                @Override
                public boolean hasNext() {
                    return this.remainingSetBits != 0;
                }

                @Override
                public E next() {
                    int index = Integer.numberOfTrailingZeros(this.remainingSetBits);
                    if (index == 32) {
                        throw new NoSuchElementException();
                    }
                    this.remainingSetBits &= ~(1 << index);
                    return this.elements.get(index);
                }

                @Override
                public final void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return Integer.bitCount(this.mask);
        }

        @Override
        public boolean contains(Object o) {
            Integer index = this.inputSet.get(o);
            return index != null && (this.mask & 1 << index) != 0;
        }
    }

    private static class PowerSet<E>
    extends AbstractSet<Set<E>> {
        private final Map<E, Integer> input;

        PowerSet(Set<E> set) {
            Assert.isTrue(set.size() < 32, "Too many elements to create a power set " + set.size());
            this.input = new LinkedHashMap<E, Integer>(set.size());
            int i = set.size();
            for (E e : set) {
                this.input.put(e, i--);
            }
        }

        @Override
        public Iterator<Set<E>> iterator() {
            return new ReverseIndexedListIterator<Set<E>>(this.size()){

                @Override
                protected Set<E> get(int setBits) {
                    return new SubSet(PowerSet.this.input, setBits);
                }
            };
        }

        @Override
        public int size() {
            return 1 << this.input.size();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Set) {
                Set set = (Set)o;
                return this.input.keySet().containsAll(set);
            }
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof PowerSet) {
                PowerSet that = (PowerSet)o;
                return this.input.equals(that.input);
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return this.input.keySet().hashCode() << this.input.size() - 1;
        }
    }

    private static class SetLengthComparator<T>
    implements Comparator<Set<T>> {
        private SetLengthComparator() {
        }

        @Override
        public int compare(Set<T> o1, Set<T> o2) {
            return -Integer.compare(o1.size(), o2.size());
        }
    }

    static class SimpleShard {
        private final String index;
        private final Integer id;

        private SimpleShard(String index, Integer id) {
            this.index = index;
            this.id = id;
        }

        static SimpleShard from(Shard shard) {
            return new SimpleShard(shard.getIndex(), shard.getName());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleShard other = (SimpleShard)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.index == null ? other.index != null : !this.index.equals(other.index));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SimpleShard [index=").append(this.index).append(", id=").append(this.id).append("]");
            return builder.toString();
        }
    }
}

