/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.rdd;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.TaskContext;
import org.apache.spark.package$;
import org.apache.spark.util.TaskCompletionListener;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.hadoop.util.ReflectionUtils;
import scala.Function0;
import scala.runtime.AbstractFunction0;
import scala.runtime.BoxedUnit;

abstract class CompatUtils {
    private static final boolean SPARK_11_AVAILABLE;
    private static final Class<?> SCHEMA_RDD_LIKE_CLASS;

    CompatUtils() {
    }

    static void addOnCompletition(TaskContext taskContext, Function0<?> function) {
        if (SPARK_11_AVAILABLE) {
            Spark11TaskContext.addOnCompletition(taskContext, function);
        } else {
            Spark10TaskContext.addOnCompletition(taskContext, function);
        }
    }

    static boolean isInterrupted(TaskContext taskContext) {
        return SPARK_11_AVAILABLE ? Spark11TaskContext.isInterrupted(taskContext) : Spark10TaskContext.isInterrupted(taskContext);
    }

    static void warnSchemaRDD(Object rdd, Log log) {
        if (rdd != null && SCHEMA_RDD_LIKE_CLASS != null && SCHEMA_RDD_LIKE_CLASS.isAssignableFrom(rdd.getClass())) {
            log.warn((Object)"basic RDD saveToEs() called on a Spark SQL SchemaRDD; typically this is a mistake(as the SQL schema will be ignored). Use 'org.elasticsearch.spark.sql' package instead");
        }
    }

    static {
        boolean isEshForSpark13;
        SPARK_11_AVAILABLE = ObjectUtils.isClassPresent("org.apache.spark.util.TaskCompletionListener", SparkConf.class.getClassLoader());
        Class<?> clz = null;
        try {
            clz = Class.forName("org.apache.spark.sql.SchemaRDDLike", false, CompatUtils.class.getClassLoader());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SCHEMA_RDD_LIKE_CLASS = clz;
        boolean isSpark13 = ObjectUtils.isClassPresent("org.apache.spark.sql.DataFrame", SparkConf.class.getClassLoader());
        boolean bl = isEshForSpark13 = !ObjectUtils.isClassPresent("org.elasticsearch.spark.sql.EsSchemaRDDWriter", CompatUtils.class.getClassLoader());
        if (isSpark13 != isEshForSpark13) {
            String sparkVersion = null;
            SparkContext$ target = SparkContext$.MODULE$;
            Method sparkVersionMethod = ReflectionUtils.findMethod(target.getClass(), "SPARK_VERSION", new Class[0]);
            if (sparkVersionMethod == null) {
                target = package$.MODULE$;
                sparkVersionMethod = ReflectionUtils.findMethod(target.getClass(), "SPARK_VERSION", new Class[0]);
            }
            sparkVersion = sparkVersionMethod == null ? (isSpark13 ? "1.3+" : "1.0-1.2") : (String)ReflectionUtils.invoke(sparkVersionMethod, target, new Object[0]);
            LogFactory.getLog((String)"org.elasticsearch.spark.rdd.EsSpark").warn((Object)String.format("Incorrect classpath detected; Elasticsearch Spark compiled for Spark %s but used with Spark %s", isEshForSpark13 ? "1.3 (or higher)" : "1.0-1.2", sparkVersion));
        }
    }

    private static abstract class Spark11TaskContext {
        private Spark11TaskContext() {
        }

        static void addOnCompletition(TaskContext taskContext, final Function0<?> function) {
            taskContext.addTaskCompletionListener(new TaskCompletionListener(){

                public void onTaskCompletion(TaskContext context) {
                    function.apply();
                }
            });
        }

        static boolean isInterrupted(TaskContext taskContext) {
            return taskContext.isInterrupted();
        }
    }

    private static abstract class Spark10TaskContext {
        private static Field INTERRUPTED_FIELD;

        private Spark10TaskContext() {
        }

        static void addOnCompletition(TaskContext taskContext, final Function0<?> function) {
            taskContext.addOnCompleteCallback((Function0)new AbstractFunction0(){

                public BoxedUnit apply() {
                    function.apply();
                    return BoxedUnit.UNIT;
                }
            });
        }

        static boolean isInterrupted(TaskContext taskContext) {
            return (Boolean)ReflectionUtils.getField(INTERRUPTED_FIELD, taskContext);
        }

        static {
            Field field = ReflectionUtils.findField(TaskContext.class, "interrupted");
            ReflectionUtils.makeAccessible(field);
            INTERRUPTED_FIELD = field;
        }
    }
}

