/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal.proxy.processors.invocation;

import jakarta.ws.rs.core.Cookie;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.proxy.processors.InvocationProcessor;

public class CookieParamProcessor
implements InvocationProcessor {
    private String cookieName;
    protected Annotation[] annotations;
    protected Type type;

    public CookieParamProcessor(String cookieName) {
        this.cookieName = cookieName;
    }

    public CookieParamProcessor(String cookieName, Type type, Annotation[] annotations) {
        this.cookieName = cookieName;
        this.annotations = annotations;
        this.type = type;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    @Override
    public void process(ClientInvocation invocation, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Cookie) {
            Cookie cookie = (Cookie)object;
            invocation.getHeaders().cookie(cookie);
        } else {
            ClientConfiguration cc = invocation.getClientConfiguration();
            String s = this.annotations != null && this.type != null ? cc.toString(object, this.type, this.annotations) : cc.toString(object);
            Cookie ck1 = ((Cookie.Builder)new Cookie.Builder(this.cookieName).value(s)).build();
            invocation.getHeaders().cookie(ck1);
        }
    }
}

