/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex.v1;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.bittrex.v1.BittrexUtils;
import org.knowm.xchange.bittrex.v1.dto.account.BittrexBalance;
import org.knowm.xchange.bittrex.v1.dto.marketdata.BittrexLevel;
import org.knowm.xchange.bittrex.v1.dto.marketdata.BittrexSymbol;
import org.knowm.xchange.bittrex.v1.dto.marketdata.BittrexTicker;
import org.knowm.xchange.bittrex.v1.dto.marketdata.BittrexTrade;
import org.knowm.xchange.bittrex.v1.dto.trade.BittrexLimitOrder;
import org.knowm.xchange.bittrex.v1.dto.trade.BittrexOpenOrder;
import org.knowm.xchange.bittrex.v1.dto.trade.BittrexUserTrade;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.UserTrade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BittrexAdapters {
    public static final Logger log = LoggerFactory.getLogger(BittrexAdapters.class);

    private BittrexAdapters() {
    }

    public static List<CurrencyPair> adaptCurrencyPairs(Collection<BittrexSymbol> bittrexSymbol) {
        ArrayList<CurrencyPair> currencyPairs = new ArrayList<CurrencyPair>();
        for (BittrexSymbol symbol : bittrexSymbol) {
            currencyPairs.add(BittrexAdapters.adaptCurrencyPair(symbol));
        }
        return currencyPairs;
    }

    public static CurrencyPair adaptCurrencyPair(BittrexSymbol bittrexSymbol) {
        String baseSymbol = bittrexSymbol.getMarketCurrency();
        String counterSymbol = bittrexSymbol.getBaseCurrency();
        return new CurrencyPair(baseSymbol, counterSymbol);
    }

    public static List<LimitOrder> adaptOpenOrders(List<BittrexOpenOrder> bittrexOpenOrders) {
        ArrayList<LimitOrder> openOrders = new ArrayList<LimitOrder>();
        for (BittrexOpenOrder order : bittrexOpenOrders) {
            openOrders.add(BittrexAdapters.adaptOpenOrder(order));
        }
        return openOrders;
    }

    public static BittrexLimitOrder adaptOpenOrder(BittrexOpenOrder bittrexOpenOrder) {
        Order.OrderType type = bittrexOpenOrder.getOrderType().equalsIgnoreCase("LIMIT_SELL") ? Order.OrderType.ASK : Order.OrderType.BID;
        String[] currencies = bittrexOpenOrder.getExchange().split("-");
        CurrencyPair pair = new CurrencyPair(currencies[1], currencies[0]);
        return new BittrexLimitOrder(type, bittrexOpenOrder.getQuantityRemaining(), pair, bittrexOpenOrder.getOrderUuid(), BittrexUtils.toDate(bittrexOpenOrder.getOpened()), bittrexOpenOrder.getLimit(), bittrexOpenOrder.getQuantityRemaining(), bittrexOpenOrder.getPricePerUnit());
    }

    public static List<LimitOrder> adaptOrders(BittrexLevel[] orders, CurrencyPair currencyPair, String orderType, String id) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>(orders.length);
        for (BittrexLevel order : orders) {
            limitOrders.add(BittrexAdapters.adaptOrder(order.getAmount(), order.getPrice(), currencyPair, orderType, id));
        }
        return limitOrders;
    }

    public static LimitOrder adaptOrder(BigDecimal amount, BigDecimal price, CurrencyPair currencyPair, String orderTypeString, String id) {
        Order.OrderType orderType = orderTypeString.equalsIgnoreCase("bid") ? Order.OrderType.BID : Order.OrderType.ASK;
        return new LimitOrder(orderType, amount, currencyPair, id, null, price);
    }

    public static Trade adaptTrade(BittrexTrade trade, CurrencyPair currencyPair) {
        Order.OrderType orderType = trade.getOrderType().equalsIgnoreCase("BUY") ? Order.OrderType.BID : Order.OrderType.ASK;
        BigDecimal amount = trade.getQuantity();
        BigDecimal price = trade.getPrice();
        Date date = BittrexUtils.toDate(trade.getTimeStamp());
        String tradeId = String.valueOf(trade.getId());
        return new Trade(orderType, amount, currencyPair, price, date, tradeId);
    }

    public static Trades adaptTrades(BittrexTrade[] trades, CurrencyPair currencyPair) {
        ArrayList<Trade> tradesList = new ArrayList<Trade>(trades.length);
        long lastTradeId = 0L;
        for (BittrexTrade trade : trades) {
            long tradeId = Long.valueOf(trade.getId());
            if (tradeId > lastTradeId) {
                lastTradeId = tradeId;
            }
            tradesList.add(BittrexAdapters.adaptTrade(trade, currencyPair));
        }
        return new Trades(tradesList, lastTradeId, Trades.TradeSortType.SortByID);
    }

    public static Ticker adaptTicker(BittrexTicker bittrexTicker, CurrencyPair currencyPair) {
        BigDecimal last = bittrexTicker.getLast();
        BigDecimal bid = bittrexTicker.getBid();
        BigDecimal ask = bittrexTicker.getAsk();
        BigDecimal high = bittrexTicker.getHigh();
        BigDecimal low = bittrexTicker.getLow();
        BigDecimal volume = bittrexTicker.getVolume();
        Date timestamp = BittrexUtils.toDate(bittrexTicker.getTimeStamp());
        return new Ticker.Builder().currencyPair(currencyPair).last(last).bid(bid).ask(ask).high(high).low(low).volume(volume).timestamp(timestamp).build();
    }

    public static Wallet adaptWallet(List<BittrexBalance> balances) {
        ArrayList<Balance> wallets = new ArrayList<Balance>(balances.size());
        for (BittrexBalance balance : balances) {
            wallets.add(new Balance(Currency.getInstance((String)balance.getCurrency().toUpperCase()), balance.getBalance(), balance.getAvailable(), balance.getBalance().subtract(balance.getAvailable()).subtract(balance.getPending()), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, balance.getPending()));
        }
        return new Wallet(wallets);
    }

    public static List<UserTrade> adaptUserTrades(List<BittrexUserTrade> bittrexUserTrades) {
        ArrayList<UserTrade> trades = new ArrayList<UserTrade>();
        for (BittrexUserTrade bittrexTrade : bittrexUserTrades) {
            trades.add(BittrexAdapters.adaptUserTrade(bittrexTrade));
        }
        return trades;
    }

    public static UserTrade adaptUserTrade(BittrexUserTrade trade) {
        String[] currencies = trade.getExchange().split("-");
        CurrencyPair currencyPair = new CurrencyPair(currencies[1], currencies[0]);
        Order.OrderType orderType = trade.getOrderType().equalsIgnoreCase("LIMIT_BUY") ? Order.OrderType.BID : Order.OrderType.ASK;
        BigDecimal amount = trade.getQuantity().subtract(trade.getQuantityRemaining());
        Date date = BittrexUtils.toDate(trade.getClosed());
        String orderId = String.valueOf(trade.getOrderUuid());
        BigDecimal price = trade.getPricePerUnit();
        if (price == null) {
            price = trade.getLimit();
        }
        return new UserTrade(orderType, amount, currencyPair, price, date, orderId, orderId, trade.getCommission(), currencyPair.counter);
    }

    public static ExchangeMetaData adaptMetaData(List<BittrexSymbol> rawSymbols, ExchangeMetaData metaData) {
        List<CurrencyPair> currencyPairs = BittrexAdapters.adaptCurrencyPairs(rawSymbols);
        Map pairsMap = metaData.getCurrencyPairs();
        Map currenciesMap = metaData.getCurrencies();
        for (CurrencyPair c : currencyPairs) {
            if (!pairsMap.containsKey(c)) {
                pairsMap.put(c, null);
            }
            if (!currenciesMap.containsKey(c.base)) {
                currenciesMap.put(c.base, null);
            }
            if (currenciesMap.containsKey(c.counter)) continue;
            currenciesMap.put(c.counter, null);
        }
        return metaData;
    }
}

