/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex.v1.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bittrex.v1.dto.account.BittrexBalance;
import org.knowm.xchange.bittrex.v1.dto.account.BittrexBalancesResponse;
import org.knowm.xchange.bittrex.v1.dto.account.BittrexDepositAddressResponse;
import org.knowm.xchange.bittrex.v1.dto.account.BittrexDepositHistory;
import org.knowm.xchange.bittrex.v1.dto.account.BittrexDepositsHistoryResponse;
import org.knowm.xchange.bittrex.v1.dto.account.BittrexWithdrawResponse;
import org.knowm.xchange.bittrex.v1.dto.account.BittrexWithdrawalHistory;
import org.knowm.xchange.bittrex.v1.dto.account.BittrexWithdrawalsHistoryResponse;
import org.knowm.xchange.bittrex.v1.service.BittrexBaseService;
import org.knowm.xchange.exceptions.ExchangeException;
import si.mazi.rescu.SynchronizedValueFactory;

public class BittrexAccountServiceRaw
extends BittrexBaseService {
    public BittrexAccountServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public List<BittrexBalance> getBittrexAccountInfo() throws IOException {
        BittrexBalancesResponse response = this.bittrexAuthenticated.balances(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        if (response.getSuccess()) {
            return response.getResult();
        }
        throw new ExchangeException(response.getMessage());
    }

    public String getBittrexDepositAddress(String currency) throws IOException {
        BittrexDepositAddressResponse response = this.bittrexAuthenticated.getdepositaddress(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currency);
        if (response.getSuccess().booleanValue()) {
            return response.getResult().getAddress();
        }
        throw new ExchangeException(response.getMessage());
    }

    public List<BittrexWithdrawalHistory> getWithdrawalsHistory() throws IOException {
        BittrexWithdrawalsHistoryResponse response = this.bittrexAuthenticated.getwithdrawalhistory(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        if (response.getSuccess().booleanValue()) {
            return response.getResult();
        }
        throw new ExchangeException(response.getMessage());
    }

    public List<BittrexDepositHistory> getDepositsHistory() throws IOException {
        BittrexDepositsHistoryResponse response = this.bittrexAuthenticated.getdeposithistory(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        if (response.getSuccess().booleanValue()) {
            return response.getResult();
        }
        throw new ExchangeException(response.getMessage());
    }

    public String withdraw(String currencyCode, BigDecimal amount, String address, String paymentId) throws IOException {
        BittrexWithdrawResponse response = this.bittrexAuthenticated.withdraw(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currencyCode, amount.toPlainString(), address, paymentId);
        if (response.getSuccess().booleanValue()) {
            return response.getResult().getUuid();
        }
        throw new ExchangeException(response.getMessage());
    }
}

