/*
 * Decompiled with CFR 0.152.
 */
package org.linuxstuff.mojo.licensing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.neo4j.build.plugins:licensing-maven-plugin:1.7.7", 0);
        this.append(sb, "", 0);
        this.append(sb, "Licensing Maven Mojo", 0);
        this.append(sb, "Forked from http://github.com/idcmp/licensing-maven-plugin", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 4 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "aggregate".equals(this.goal)) {
            this.append(sb, "licensing:aggregate", 0);
            this.append(sb, "Aggregate mojo. Will walk your reactor building in memory licensing reports making them into one giant report. This mojo does not check for missing or disliked artifacts (use CheckMojo for that).", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "aggregatedThirdPartyLicensingFilename (Default: aggregated-third-party-licensing.xml)", 2);
                this.append(sb, "The name of the the XML file which contains the aggregated licensing information for artifacts.", 3);
                this.append(sb, "Expression: ${aggregatedThirdPartyLicensingFilename}", 3);
                this.append(sb, "", 0);
                this.append(sb, "appendText", 2);
                this.append(sb, "File to append to the text-based report.", 3);
                this.append(sb, "Expression: ${appendText}", 3);
                this.append(sb, "", 0);
                this.append(sb, "checkExistingLicensesFile", 2);
                this.append(sb, "File to append to the text-based report.", 3);
                this.append(sb, "Expression: ${checkExistingLicensesFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "checkExistingNoticeFile", 2);
                this.append(sb, "File to append to the text-based report.", 3);
                this.append(sb, "Expression: ${checkExistingNoticeFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedArtifacts", 2);
                this.append(sb, "A filter to exclude some ArtifactsIds", 3);
                this.append(sb, "Expression: ${licensing.excludedArtifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedGroups", 2);
                this.append(sb, "A filter to exclude some GroupIds", 3);
                this.append(sb, "Expression: ${licensing.excludedGroups}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedScopes (Default: system)", 2);
                this.append(sb, "A filter to exclude some scopes.", 3);
                this.append(sb, "Expression: ${licensing.excludedScopes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failIfDisliked (Default: true)", 2);
                this.append(sb, "A fail the build if any artifacts have disliked licenses.", 3);
                this.append(sb, "Expression: ${failIfDisliked}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failIfMissing (Default: true)", 2);
                this.append(sb, "A fail the build if any artifacts are missing licensing information.", 3);
                this.append(sb, "Expression: ${failIfMissing}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedArtifacts", 2);
                this.append(sb, "A filter to include only some ArtifactsIds", 3);
                this.append(sb, "Expression: ${licensing.includedArtifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedGroups", 2);
                this.append(sb, "A filter to include only some GroupIds", 3);
                this.append(sb, "Expression: ${licensing.includedGroups}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedScopes", 2);
                this.append(sb, "A filter to include only some scopes, if let empty then all scopes will be used (no filter).", 3);
                this.append(sb, "Expression: ${licensing.includedScopes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeOnlyLikedInReport (Default: true)", 2);
                this.append(sb, "If using liked licenses, only use those in the report.", 3);
                this.append(sb, "Expression: ${includeOnlyLikedInReport}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeTransitiveDependencies (Default: true)", 2);
                this.append(sb, "Include transitive dependencies when downloading license files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "licensingRequirementFiles", 2);
                this.append(sb, "Location of license requirement XML files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "listPrependText", 2);
                this.append(sb, "File to prepend to the text-based report with full license texts.", 3);
                this.append(sb, "Expression: ${listPrependText}", 3);
                this.append(sb, "", 0);
                this.append(sb, "listReport", 2);
                this.append(sb, "The name of the output txt file which contains full text licenses. Only kicks in as part of generating a plain text report.", 3);
                this.append(sb, "Expression: ${listReport}", 3);
                this.append(sb, "", 0);
                this.append(sb, "overwrite (Default: false)", 2);
                this.append(sb, "Overwrite existing license/notice.txt files.", 3);
                this.append(sb, "Expression: ${overwrite}", 3);
                this.append(sb, "", 0);
                this.append(sb, "plainTextReport (Default: false)", 2);
                this.append(sb, "Output the result as a plain text file.", 3);
                this.append(sb, "Expression: ${writeTextReport}", 3);
                this.append(sb, "", 0);
                this.append(sb, "prependText", 2);
                this.append(sb, "File to prepend to the text-based report.", 3);
                this.append(sb, "Expression: ${prependText}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Should we skip doing licensing checks?", 3);
                this.append(sb, "Expression: ${licensing.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "thirdPartyLicensingFilename (Default: third-party-licensing.xml)", 2);
                this.append(sb, "The name of the the XML file which contains licensing information one artifact.", 3);
                this.append(sb, "Expression: ${thirdPartyLicensingFilename}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "check".equals(this.goal)) {
            this.append(sb, "licensing:check", 0);
            this.append(sb, "Determine licensing information of all dependencies. This is generally obtained by dependencies providing a license block in their POM. However this plugin supports a requirements file which can supplement licensing information for artifacts missing licensing information.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "aggregatedThirdPartyLicensingFilename (Default: aggregated-third-party-licensing.xml)", 2);
                this.append(sb, "The name of the the XML file which contains the aggregated licensing information for artifacts.", 3);
                this.append(sb, "Expression: ${aggregatedThirdPartyLicensingFilename}", 3);
                this.append(sb, "", 0);
                this.append(sb, "appendText", 2);
                this.append(sb, "File to append to the text-based report.", 3);
                this.append(sb, "Expression: ${appendText}", 3);
                this.append(sb, "", 0);
                this.append(sb, "checkExistingLicensesFile", 2);
                this.append(sb, "File to append to the text-based report.", 3);
                this.append(sb, "Expression: ${checkExistingLicensesFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "checkExistingNoticeFile", 2);
                this.append(sb, "File to append to the text-based report.", 3);
                this.append(sb, "Expression: ${checkExistingNoticeFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedArtifacts", 2);
                this.append(sb, "A filter to exclude some ArtifactsIds", 3);
                this.append(sb, "Expression: ${licensing.excludedArtifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedGroups", 2);
                this.append(sb, "A filter to exclude some GroupIds", 3);
                this.append(sb, "Expression: ${licensing.excludedGroups}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedScopes (Default: system)", 2);
                this.append(sb, "A filter to exclude some scopes.", 3);
                this.append(sb, "Expression: ${licensing.excludedScopes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failIfDisliked (Default: true)", 2);
                this.append(sb, "A fail the build if any artifacts have disliked licenses.", 3);
                this.append(sb, "Expression: ${failIfDisliked}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failIfMissing (Default: true)", 2);
                this.append(sb, "A fail the build if any artifacts are missing licensing information.", 3);
                this.append(sb, "Expression: ${failIfMissing}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedArtifacts", 2);
                this.append(sb, "A filter to include only some ArtifactsIds", 3);
                this.append(sb, "Expression: ${licensing.includedArtifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedGroups", 2);
                this.append(sb, "A filter to include only some GroupIds", 3);
                this.append(sb, "Expression: ${licensing.includedGroups}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedScopes", 2);
                this.append(sb, "A filter to include only some scopes, if let empty then all scopes will be used (no filter).", 3);
                this.append(sb, "Expression: ${licensing.includedScopes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeOnlyLikedInReport (Default: true)", 2);
                this.append(sb, "If using liked licenses, only use those in the report.", 3);
                this.append(sb, "Expression: ${includeOnlyLikedInReport}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeTransitiveDependencies (Default: true)", 2);
                this.append(sb, "Include transitive dependencies when downloading license files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "licensingRequirementFiles", 2);
                this.append(sb, "Location of license requirement XML files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "listPrependText", 2);
                this.append(sb, "File to prepend to the text-based report with full license texts.", 3);
                this.append(sb, "Expression: ${listPrependText}", 3);
                this.append(sb, "", 0);
                this.append(sb, "listReport", 2);
                this.append(sb, "The name of the output txt file which contains full text licenses. Only kicks in as part of generating a plain text report.", 3);
                this.append(sb, "Expression: ${listReport}", 3);
                this.append(sb, "", 0);
                this.append(sb, "overwrite (Default: false)", 2);
                this.append(sb, "Overwrite existing license/notice.txt files.", 3);
                this.append(sb, "Expression: ${overwrite}", 3);
                this.append(sb, "", 0);
                this.append(sb, "plainTextReport (Default: false)", 2);
                this.append(sb, "Output the result as a plain text file.", 3);
                this.append(sb, "Expression: ${writeTextReport}", 3);
                this.append(sb, "", 0);
                this.append(sb, "prependText", 2);
                this.append(sb, "File to prepend to the text-based report.", 3);
                this.append(sb, "Expression: ${prependText}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Should we skip doing licensing checks?", 3);
                this.append(sb, "Expression: ${licensing.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "thirdPartyLicensingFilename (Default: third-party-licensing.xml)", 2);
                this.append(sb, "The name of the the XML file which contains licensing information one artifact.", 3);
                this.append(sb, "Expression: ${thirdPartyLicensingFilename}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "collect-reports".equals(this.goal)) {
            this.append(sb, "licensing:collect-reports", 0);
            this.append(sb, "(no description available)", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "aggregatedThirdPartyLicensingFilename (Default: aggregated-third-party-licensing.xml)", 2);
                this.append(sb, "The name of the the XML file which contains the aggregated licensing information for artifacts.", 3);
                this.append(sb, "Expression: ${aggregatedThirdPartyLicensingFilename}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedArtifacts", 2);
                this.append(sb, "A filter to exclude some ArtifactsIds", 3);
                this.append(sb, "Expression: ${licensing.excludedArtifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedGroups", 2);
                this.append(sb, "A filter to exclude some GroupIds", 3);
                this.append(sb, "Expression: ${licensing.excludedGroups}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedScopes (Default: system)", 2);
                this.append(sb, "A filter to exclude some scopes.", 3);
                this.append(sb, "Expression: ${licensing.excludedScopes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedArtifacts", 2);
                this.append(sb, "A filter to include only some ArtifactsIds", 3);
                this.append(sb, "Expression: ${licensing.includedArtifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedGroups", 2);
                this.append(sb, "A filter to include only some GroupIds", 3);
                this.append(sb, "Expression: ${licensing.includedGroups}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedScopes", 2);
                this.append(sb, "A filter to include only some scopes, if let empty then all scopes will be used (no filter).", 3);
                this.append(sb, "Expression: ${licensing.includedScopes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeTransitiveDependencies (Default: true)", 2);
                this.append(sb, "Include transitive dependencies when downloading license files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "licensingRequirementFiles", 2);
                this.append(sb, "Location of license requirement XML files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Should we skip doing licensing checks?", 3);
                this.append(sb, "Expression: ${licensing.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "thirdPartyLicensingFilename (Default: third-party-licensing.xml)", 2);
                this.append(sb, "The name of the the XML file which contains licensing information one artifact.", 3);
                this.append(sb, "Expression: ${thirdPartyLicensingFilename}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "licensing:help", 0);
            this.append(sb, "Display help information on licensing-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0licensing:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

