/*
 * Decompiled with CFR 0.152.
 */
package org.linuxstuff.mojo.licensing;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.linuxstuff.mojo.licensing.CheckMojo;
import org.linuxstuff.mojo.licensing.model.LicensingReport;

public class AggregateReportMojo
extends CheckMojo {
    private MavenProjectHelper projectHelper;
    private List<MavenProject> reactorProjects;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.project.isExecutionRoot()) {
            this.getLog().debug((CharSequence)(this.project.getId() + " is not execution root, not making aggregated licensing report."));
            return;
        }
        this.readLicensingRequirements();
        LicensingReport bigReport = new LicensingReport();
        for (MavenProject project : this.reactorProjects) {
            if (!this.shouldReportOn(project)) continue;
            LicensingReport report = this.generateReport(project);
            bigReport.combineWith(report);
        }
        File file = new File(this.project.getBuild().getDirectory(), this.aggregatedThirdPartyLicensingFilename);
        bigReport.writeReport(file);
    }

    private boolean shouldReportOn(MavenProject project) {
        String licensingSkip = (String)project.getProperties().get("licensing.skip");
        if (licensingSkip != null && Boolean.parseBoolean(licensingSkip)) {
            this.getLog().info((CharSequence)("Licensing: Skipping project " + project));
            return false;
        }
        return true;
    }
}

