/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractTypeScriptClientCodegen;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.utils.StringUtils;

public class TypeScriptAureliaClientCodegen
extends AbstractTypeScriptClientCodegen {
    public TypeScriptAureliaClientCodegen() {
        this.apiTemplateFiles.put("api.mustache", ".ts");
        this.importMapping.clear();
        this.outputFolder = "generated-code/typescript-aurelia";
        this.templateDir = "typescript-aurelia";
        this.embeddedTemplateDir = "typescript-aurelia";
    }

    @Override
    public String getName() {
        return "typescript-aurelia";
    }

    @Override
    public String getHelp() {
        return "Generates a TypeScript client library for the Aurelia framework (beta).";
    }

    @Override
    public String getNpmName() {
        return this.npmName;
    }

    @Override
    public void setNpmName(String npmName) {
        this.npmName = npmName;
    }

    @Override
    public String getNpmVersion() {
        return this.npmVersion;
    }

    @Override
    public void setNpmVersion(String npmVersion) {
        this.npmVersion = npmVersion;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.supportingFiles.add(new SupportingFile("models.mustache", "", "models.ts"));
        this.supportingFiles.add(new SupportingFile("index.ts.mustache", "", "index.ts"));
        this.supportingFiles.add(new SupportingFile("Api.ts.mustache", "", "Api.ts"));
        this.supportingFiles.add(new SupportingFile("AuthStorage.ts.mustache", "", "AuthStorage.ts"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("README.md", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("package.json.mustache", "", "package.json"));
        this.supportingFiles.add(new SupportingFile("tsconfig.json.mustache", "", "tsconfig.json"));
        this.supportingFiles.add(new SupportingFile("tslint.json.mustache", "", "tslint.json"));
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<ModelMap> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        HashSet<String> modelImports = new HashSet<String>();
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            op.httpMethod = StringUtils.camelize(op.httpMethod.toLowerCase(Locale.ROOT));
            for (CodegenParameter param : op.allParams) {
                if (param.isPrimitiveType || param.isArray || "any".equals(param.dataType)) continue;
                modelImports.add(param.dataType);
            }
            if (op.returnBaseType == null || op.returnTypeIsPrimitive) continue;
            modelImports.add(op.returnBaseType);
        }
        objs.put("modelImports", modelImports);
        return objs;
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        List<ModelMap> models = this.postProcessModelsEnum(objs).getModels();
        for (ModelMap mo : models) {
            CodegenModel cm = mo.getModel();
            cm.imports = new TreeSet<String>(cm.imports);
            for (CodegenProperty var : cm.vars) {
                if (!Boolean.TRUE.equals(var.isEnum)) continue;
                var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + var.enumName);
                var.enumName = cm.classname + var.enumName;
            }
        }
        return objs;
    }
}

