/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.subsingle.constraintmatchtotalbestscore;

import io.micrometer.core.instrument.Tags;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.optaplanner.benchmark.config.statistic.SingleStatisticType;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.PureSubSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.StatisticRegistry;
import org.optaplanner.benchmark.impl.statistic.common.MillisecondsSpentNumberFormat;
import org.optaplanner.benchmark.impl.statistic.subsingle.constraintmatchtotalbestscore.ConstraintMatchTotalBestScoreStatisticPoint;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.config.solver.monitoring.SolverMetric;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.solver.DefaultSolver;

public class ConstraintMatchTotalBestScoreSubSingleStatistic<Solution_>
extends PureSubSingleStatistic<Solution_, ConstraintMatchTotalBestScoreStatisticPoint> {
    @XmlTransient
    protected List<File> graphFileList = null;

    ConstraintMatchTotalBestScoreSubSingleStatistic() {
    }

    public ConstraintMatchTotalBestScoreSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        super(subSingleBenchmarkResult, SingleStatisticType.CONSTRAINT_MATCH_TOTAL_BEST_SCORE);
    }

    @Override
    public List<File> getGraphFileList() {
        return this.graphFileList;
    }

    @Override
    public void open(StatisticRegistry<Solution_> registry, Tags runTag, Solver<Solution_> solver) {
        DefaultSolver defaultSolver = (DefaultSolver)solver;
        defaultSolver.getSolverScope().getScoreDirector().overwriteConstraintMatchEnabledPreference(true);
        registry.addListener(SolverMetric.CONSTRAINT_MATCH_TOTAL_BEST_SCORE, timeMillisSpent -> registry.extractConstraintSummariesFromMeters(SolverMetric.CONSTRAINT_MATCH_TOTAL_BEST_SCORE, runTag, constraintSummary -> this.pointList.add(new ConstraintMatchTotalBestScoreStatisticPoint((long)timeMillisSpent, constraintSummary.getConstraintPackage(), constraintSummary.getConstraintName(), constraintSummary.getCount(), (Score)constraintSummary.getScore()))));
    }

    @Override
    protected String getCsvHeader() {
        return ConstraintMatchTotalBestScoreStatisticPoint.buildCsvLine("timeMillisSpent", "constraintPackage", "constraintName", "constraintMatchCount", "scoreTotal");
    }

    @Override
    protected ConstraintMatchTotalBestScoreStatisticPoint createPointFromCsvLine(ScoreDefinition<?> scoreDefinition, List<String> csvLine) {
        return new ConstraintMatchTotalBestScoreStatisticPoint(Long.parseLong(csvLine.get(0)), csvLine.get(1), csvLine.get(2), Integer.parseInt(csvLine.get(3)), scoreDefinition.parseScore(csvLine.get(4)));
    }

    @Override
    public void writeGraphFiles(BenchmarkReport benchmarkReport) {
        ArrayList constraintIdToWeightSeriesMapList = new ArrayList(15);
        for (ConstraintMatchTotalBestScoreStatisticPoint point : this.getPointList()) {
            long timeMillisSpent = point.getTimeMillisSpent();
            double[] levelValues = point.getScoreTotal().toLevelDoubles();
            for (int i = 0; i < levelValues.length && i < 15; ++i) {
                Object constraintIdToWeightSeriesMap;
                XYSeries weightSeries;
                if (i >= constraintIdToWeightSeriesMapList.size()) {
                    constraintIdToWeightSeriesMapList.add(new LinkedHashMap());
                }
                if (levelValues[i] == ((weightSeries = (constraintIdToWeightSeriesMap = (Map)constraintIdToWeightSeriesMapList.get(i)).computeIfAbsent(point.getConstraintId(), k -> new XYSeries((Comparable)((Object)(point.getConstraintName() + " weight"))))).getItemCount() == 0 ? 0.0 : weightSeries.getY(weightSeries.getItemCount() - 1).doubleValue())) continue;
                weightSeries.add((double)timeMillisSpent, levelValues[i]);
            }
        }
        long timeMillisSpent = this.subSingleBenchmarkResult.getTimeMillisSpent();
        for (Map map : constraintIdToWeightSeriesMapList) {
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                XYSeries weightSeries = (XYSeries)it.next().getValue();
                if (weightSeries.getItemCount() == 0) {
                    it.remove();
                    continue;
                }
                weightSeries.add((double)timeMillisSpent, weightSeries.getY(weightSeries.getItemCount() - 1).doubleValue());
            }
        }
        this.graphFileList = new ArrayList<File>(constraintIdToWeightSeriesMapList.size());
        for (int scoreLevelIndex = 0; scoreLevelIndex < constraintIdToWeightSeriesMapList.size(); ++scoreLevelIndex) {
            XYPlot xYPlot = this.createPlot(benchmarkReport, scoreLevelIndex);
            XYStepRenderer renderer = new XYStepRenderer();
            xYPlot.setRenderer((XYItemRenderer)renderer);
            XYSeriesCollection seriesCollection = new XYSeriesCollection();
            for (XYSeries series : ((Map)constraintIdToWeightSeriesMapList.get(scoreLevelIndex)).values()) {
                seriesCollection.addSeries(series);
            }
            xYPlot.setDataset((XYDataset)seriesCollection);
            String scoreLevelLabel = this.subSingleBenchmarkResult.getSingleBenchmarkResult().getProblemBenchmarkResult().findScoreLevelLabel(scoreLevelIndex);
            JFreeChart chart = new JFreeChart(this.subSingleBenchmarkResult.getName() + " constraint match total best " + scoreLevelLabel + " diff statistic", JFreeChart.DEFAULT_TITLE_FONT, (Plot)xYPlot, true);
            this.graphFileList.add(this.writeChartToImageFile(chart, "ConstraintMatchTotalBestScoreStatisticLevel" + scoreLevelIndex));
        }
    }

    private XYPlot createPlot(BenchmarkReport benchmarkReport, int scoreLevelIndex) {
        Locale locale = benchmarkReport.getLocale();
        NumberAxis xAxis = new NumberAxis("Time spent");
        xAxis.setNumberFormatOverride((NumberFormat)new MillisecondsSpentNumberFormat(locale));
        String scoreLevelLabel = this.subSingleBenchmarkResult.getSingleBenchmarkResult().getProblemBenchmarkResult().findScoreLevelLabel(scoreLevelIndex);
        NumberAxis yAxis = new NumberAxis("Constraint match total " + scoreLevelLabel);
        yAxis.setNumberFormatOverride(NumberFormat.getInstance(locale));
        yAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot(null, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        plot.setOrientation(PlotOrientation.VERTICAL);
        return plot;
    }
}

