/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.hc.client5.http.impl.classic.AbstractHttpClientResponseHandler;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.owasp.dependencycheck.utils.DownloadFailedException;

public class ExplicitCharsetToStringResponseHandler
extends AbstractHttpClientResponseHandler<String> {
    private final Charset charset;

    public ExplicitCharsetToStringResponseHandler(Charset charset) {
        this.charset = charset;
    }

    public String handleEntity(HttpEntity entity) throws IOException {
        Charset entityCharset;
        ContentType contentType = ContentType.parseLenient((CharSequence)entity.getContentType());
        if (contentType != null && (entityCharset = contentType.getCharset()) != null && !entityCharset.equals(this.charset)) {
            throw new DownloadFailedException(String.format("Requested decoding charset %s incompatible with the explicit response charset %s.", this.charset, entityCharset));
        }
        return new String(EntityUtils.toByteArray((HttpEntity)entity), this.charset);
    }
}

