/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.authentication.AuthenticationProtocolClient;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.PasswordChangePrompt;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthPwdChangeReq;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest;
import com.sshtools.j2ssh.authentication.TerminatedStateException;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PasswordAuthenticationClient
extends SshAuthenticationClient {
    private static Log log = LogFactory.getLog((Class)PasswordAuthenticationClient.class);
    private PasswordChangePrompt changePrompt = null;
    protected String password = null;

    public final String getMethodName() {
        return "password";
    }

    public final void setPassword(String string) {
        this.password = string;
    }

    public void reset() {
        this.password = null;
    }

    public void setPasswordChangePrompt(PasswordChangePrompt passwordChangePrompt) {
        this.changePrompt = passwordChangePrompt;
    }

    public void authenticate(AuthenticationProtocolClient authenticationProtocolClient, String string) throws IOException, TerminatedStateException {
        String string2;
        if (this.getUsername() == null || this.password == null) {
            throw new AuthenticationProtocolException("Username and password cannot be null!");
        }
        authenticationProtocolClient.registerMessage(SshMsgUserAuthPwdChangeReq.class, 60);
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.write(0);
        byteArrayWriter.writeString(this.password);
        SshMsgUserAuthRequest sshMsgUserAuthRequest = new SshMsgUserAuthRequest(this.getUsername(), string, "password", byteArrayWriter.toByteArray());
        authenticationProtocolClient.sendMessage(sshMsgUserAuthRequest);
        SshMsgUserAuthPwdChangeReq sshMsgUserAuthPwdChangeReq = (SshMsgUserAuthPwdChangeReq)authenticationProtocolClient.readMessage(60);
        if (this.changePrompt != null) {
            string2 = this.changePrompt.changePassword(sshMsgUserAuthPwdChangeReq.getPrompt());
            if (string2 == null) {
                throw new TerminatedStateException(2);
            }
        } else {
            throw new TerminatedStateException(2);
        }
        log.debug((Object)"Setting new password");
        byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.write(1);
        byteArrayWriter.writeString(this.password);
        byteArrayWriter.writeString(string2);
        sshMsgUserAuthRequest = new SshMsgUserAuthRequest(this.getUsername(), string, "password", byteArrayWriter.toByteArray());
        authenticationProtocolClient.sendMessage(sshMsgUserAuthRequest);
    }

    public Properties getPersistableProperties() {
        Properties properties = new Properties();
        if (this.getUsername() != null) {
            properties.setProperty("Username", this.getUsername());
        }
        return properties;
    }

    public void setPersistableProperties(Properties properties) {
        this.setUsername(properties.getProperty("Username"));
        if (properties.getProperty("Password") != null) {
            this.setPassword(properties.getProperty("Password"));
        }
    }

    public boolean canAuthenticate() {
        return this.getUsername() != null && this.password != null;
    }
}

