/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MySqlInsertStatement
extends SQLInsertStatement {
    private boolean lowPriority = false;
    private boolean delayed = false;
    private boolean highPriority = false;
    private boolean ignore = false;
    private boolean rollbackOnFail = false;
    private final List<SQLExpr> duplicateKeyUpdate = new ArrayList<SQLExpr>();

    public MySqlInsertStatement() {
        this.dbType = "mysql";
    }

    public void cloneTo(MySqlInsertStatement x) {
        super.cloneTo(x);
        x.lowPriority = this.lowPriority;
        x.delayed = this.delayed;
        x.highPriority = this.highPriority;
        x.ignore = this.ignore;
        x.rollbackOnFail = this.rollbackOnFail;
        for (SQLExpr e : this.duplicateKeyUpdate) {
            SQLExpr e2 = e.clone();
            e2.setParent(x);
            x.duplicateKeyUpdate.add(e2);
        }
    }

    public List<SQLExpr> getDuplicateKeyUpdate() {
        return this.duplicateKeyUpdate;
    }

    public boolean isLowPriority() {
        return this.lowPriority;
    }

    public void setLowPriority(boolean lowPriority) {
        this.lowPriority = lowPriority;
    }

    public boolean isDelayed() {
        return this.delayed;
    }

    public void setDelayed(boolean delayed) {
        this.delayed = delayed;
    }

    public boolean isHighPriority() {
        return this.highPriority;
    }

    public void setHighPriority(boolean highPriority) {
        this.highPriority = highPriority;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public boolean isRollbackOnFail() {
        return this.rollbackOnFail;
    }

    public void setRollbackOnFail(boolean rollbackOnFail) {
        this.rollbackOnFail = rollbackOnFail;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor instanceof MySqlASTVisitor) {
            this.accept0((MySqlASTVisitor)visitor);
        } else {
            super.accept0(visitor);
        }
    }

    @Override
    public void output(StringBuffer buf) {
        new MySqlOutputVisitor(buf).visit(this);
    }

    protected void accept0(MySqlASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.getTableSource());
            this.acceptChild((SQLASTVisitor)visitor, this.getColumns());
            this.acceptChild((SQLASTVisitor)visitor, this.getValuesList());
            this.acceptChild((SQLASTVisitor)visitor, this.getQuery());
            this.acceptChild((SQLASTVisitor)visitor, this.getDuplicateKeyUpdate());
        }
        visitor.endVisit(this);
    }

    @Override
    public SQLInsertStatement clone() {
        MySqlInsertStatement x = new MySqlInsertStatement();
        this.cloneTo(x);
        return x;
    }
}

