/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.List;

public final class SQLSelectOrderByItem
extends SQLObjectImpl
implements SQLReplaceable {
    protected SQLExpr expr;
    protected String collate;
    protected SQLOrderingSpecification type;
    protected NullsOrderType nullsOrderType;
    protected transient SQLSelectItem resolvedSelectItem;

    public SQLSelectOrderByItem() {
    }

    public SQLSelectOrderByItem(SQLExpr expr) {
        this.setExpr(expr);
    }

    public SQLSelectOrderByItem(SQLExpr expr, SQLOrderingSpecification type) {
        this.setExpr(expr);
        this.type = type;
    }

    public SQLExpr getExpr() {
        return this.expr;
    }

    public void setExpr(SQLExpr expr) {
        if (expr != null) {
            expr.setParent(this);
        }
        this.expr = expr;
    }

    public String getCollate() {
        return this.collate;
    }

    public void setCollate(String collate) {
        this.collate = collate;
    }

    public SQLOrderingSpecification getType() {
        return this.type;
    }

    public void setType(SQLOrderingSpecification type) {
        this.type = type;
    }

    public NullsOrderType getNullsOrderType() {
        return this.nullsOrderType;
    }

    public void setNullsOrderType(NullsOrderType nullsOrderType) {
        this.nullsOrderType = nullsOrderType;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.expr);
        }
        visitor.endVisit(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.collate == null ? 0 : this.collate.hashCode());
        result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLSelectOrderByItem other = (SQLSelectOrderByItem)obj;
        if (this.collate == null ? other.collate != null : !this.collate.equals(other.collate)) {
            return false;
        }
        if (this.expr == null ? other.expr != null : !this.expr.equals(other.expr)) {
            return false;
        }
        return this.type == other.type;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (this.expr == expr) {
            this.setExpr(target);
            return true;
        }
        return false;
    }

    @Override
    public SQLSelectOrderByItem clone() {
        SQLSelectOrderByItem x = new SQLSelectOrderByItem();
        if (this.expr != null) {
            x.setExpr(this.expr.clone());
        }
        x.collate = this.collate;
        x.type = this.type;
        x.nullsOrderType = this.nullsOrderType;
        return x;
    }

    public SQLSelectItem getResolvedSelectItem() {
        return this.resolvedSelectItem;
    }

    public void setResolvedSelectItem(SQLSelectItem resolvedSelectItem) {
        this.resolvedSelectItem = resolvedSelectItem;
    }

    public boolean isClusterBy() {
        if (this.parent instanceof SQLCreateTableStatement) {
            List<SQLSelectOrderByItem> clusteredBy = ((SQLCreateTableStatement)this.parent).getClusteredBy();
            return clusteredBy.indexOf(this) != -1;
        }
        if (this.parent instanceof SQLSelectQueryBlock) {
            List<SQLSelectOrderByItem> clusterBy = ((SQLSelectQueryBlock)this.parent).getClusterByDirect();
            return clusterBy != null && clusterBy.indexOf(this) != -1;
        }
        return false;
    }

    public boolean isSortBy() {
        if (this.parent instanceof SQLCreateTableStatement) {
            List<SQLSelectOrderByItem> sortedBy = ((SQLCreateTableStatement)this.parent).getSortedBy();
            return sortedBy.indexOf(this) != -1;
        }
        if (this.parent instanceof SQLSelectQueryBlock) {
            List<SQLSelectOrderByItem> sortedBy = ((SQLSelectQueryBlock)this.parent).getSortByDirect();
            return sortedBy != null && sortedBy.indexOf(this) != -1;
        }
        return false;
    }

    public boolean isDistributeBy() {
        if (this.parent instanceof SQLSelectQueryBlock) {
            List<SQLSelectOrderByItem> distributeBy = ((SQLSelectQueryBlock)this.parent).getDistributeBy();
            return distributeBy.indexOf(this) != -1;
        }
        return false;
    }

    public static enum NullsOrderType {
        NullsFirst,
        NullsLast;


        public String toFormalString() {
            if (NullsFirst.equals((Object)this)) {
                return "NULLS FIRST";
            }
            if (NullsLast.equals((Object)this)) {
                return "NULLS LAST";
            }
            throw new IllegalArgumentException();
        }
    }
}

