/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.hive.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLSizeExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSampling;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.hive.parser.HiveExprParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectListCache;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;

public class HiveSelectParser
extends SQLSelectParser {
    public HiveSelectParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    public HiveSelectParser(SQLExprParser exprParser, SQLSelectListCache selectListCache) {
        super(exprParser, selectListCache);
    }

    public HiveSelectParser(String sql) {
        this(new HiveExprParser(sql));
    }

    protected SQLExprParser createExprParser() {
        return new HiveExprParser(this.lexer);
    }

    @Override
    protected SQLTableSource parseTableSourceRest(SQLTableSource tableSource) {
        if (this.lexer.identifierEquals(FnvHash.Constants.TABLESAMPLE) && tableSource instanceof SQLExprTableSource) {
            Lexer.SavePoint mark = this.lexer.mark();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                SQLTableSampling sampling = new SQLTableSampling();
                if (this.lexer.identifierEquals(FnvHash.Constants.BUCKET)) {
                    this.lexer.nextToken();
                    SQLExpr bucket = this.exprParser.primary();
                    sampling.setBucket(bucket);
                    if (this.lexer.token() == Token.OUT) {
                        this.lexer.nextToken();
                        this.accept(Token.OF);
                        SQLExpr outOf = this.exprParser.primary();
                        sampling.setOutOf(outOf);
                    }
                    if (this.lexer.token() == Token.ON) {
                        this.lexer.nextToken();
                        SQLExpr on = this.exprParser.expr();
                        sampling.setOn(on);
                    }
                }
                if (this.lexer.token() == Token.LITERAL_INT || this.lexer.token() == Token.LITERAL_FLOAT) {
                    SQLExpr val = this.exprParser.primary();
                    if (this.lexer.identifierEquals(FnvHash.Constants.ROWS)) {
                        this.lexer.nextToken();
                        sampling.setRows(val);
                    } else {
                        this.acceptIdentifier("PERCENT");
                        sampling.setPercent(val);
                    }
                }
                if (this.lexer.token() == Token.IDENTIFIER) {
                    String strVal = this.lexer.stringVal();
                    char first = strVal.charAt(0);
                    char last = strVal.charAt(strVal.length() - 1);
                    if (last >= 'a' && last <= 'z') {
                        last = (char)(last - 32);
                    }
                    boolean match = false;
                    if (first == '.' || first >= '0' && first <= '9') {
                        switch (last) {
                            case 'B': 
                            case 'G': 
                            case 'K': 
                            case 'M': 
                            case 'P': 
                            case 'T': {
                                match = true;
                                break;
                            }
                        }
                    }
                    SQLSizeExpr size = new SQLSizeExpr(strVal.substring(0, strVal.length() - 2), last);
                    sampling.setByteLength(size);
                    this.lexer.nextToken();
                }
                SQLExprTableSource table = (SQLExprTableSource)tableSource;
                table.setSampling(sampling);
                this.accept(Token.RPAREN);
            } else {
                this.lexer.reset(mark);
            }
        }
        return super.parseTableSourceRest(tableSource);
    }
}

