/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.lps;

import com.baidubce.BceClientConfiguration;
import com.baidubce.http.HttpMethodName;
import com.baidubce.internal.InternalRequest;
import com.baidubce.services.lps.BaseLpsClient;
import com.baidubce.services.lps.model.DirectionRequest;
import com.baidubce.services.lps.model.DirectionResponse;
import com.baidubce.services.lps.model.RouteMatrixRequest;
import com.baidubce.services.lps.model.RouteMatrixResponse;
import com.baidubce.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LpsClient
extends BaseLpsClient {
    private static final Logger log = LoggerFactory.getLogger(LpsClient.class);
    private static final String DIRECTION_URL_PATH = "/v1/lps/logistics/direction";
    private static final String ROUTE_MATRIX_URL_PATH = "/v1/lps/logistics/routematrix";

    public LpsClient() {
    }

    public LpsClient(BceClientConfiguration configuration) {
        super(configuration);
    }

    public LpsClient(String accessKey, String secretKey) {
        super(accessKey, secretKey);
    }

    public DirectionResponse direction(DirectionRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DIRECTION_URL_PATH);
        log.info("direction request: {}", (Object)JsonUtils.toJsonString(internalRequest));
        return this.invokeHttpClient(internalRequest, DirectionResponse.class);
    }

    public RouteMatrixResponse routeMatrix(RouteMatrixRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, ROUTE_MATRIX_URL_PATH);
        log.info("route matrix request: {}", (Object)JsonUtils.toJsonString(internalRequest));
        return this.invokeHttpClient(internalRequest, RouteMatrixResponse.class);
    }
}

