/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins.pagination.optimize;

import com.baomidou.mybatisplus.parser.AbstractSqlParser;
import com.baomidou.mybatisplus.parser.SqlInfo;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.select.Distinct;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;

public class JsqlParserCountOptimize
extends AbstractSqlParser {
    private static final List<SelectItem> countSelectItem = JsqlParserCountOptimize.countSelectItem();

    @Override
    public SqlInfo optimizeSql(String sql) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" JsqlParserCountOptimize sql=" + sql);
        }
        SqlInfo sqlInfo = SqlInfo.newInstance();
        try {
            Select selectStatement = (Select)CCJSqlParserUtil.parse((String)sql);
            PlainSelect plainSelect = (PlainSelect)selectStatement.getSelectBody();
            Distinct distinct = plainSelect.getDistinct();
            List groupBy = plainSelect.getGroupByColumnReferences();
            List orderBy = plainSelect.getOrderByElements();
            if (CollectionUtils.isEmpty(groupBy) && CollectionUtils.isNotEmpty(orderBy)) {
                plainSelect.setOrderByElements(null);
                sqlInfo.setOrderBy(false);
            }
            for (SelectItem item : plainSelect.getSelectItems()) {
                if (!item.toString().contains("?")) continue;
                sqlInfo.setSql(String.format("SELECT COUNT(1) FROM ( %s ) TOTAL", selectStatement.toString()));
                return sqlInfo;
            }
            if (distinct != null || CollectionUtils.isNotEmpty(groupBy)) {
                sqlInfo.setSql(String.format("SELECT COUNT(1) FROM ( %s ) TOTAL", selectStatement.toString()));
                return sqlInfo;
            }
            plainSelect.setSelectItems(countSelectItem);
            sqlInfo.setSql(selectStatement.toString());
            return sqlInfo;
        }
        catch (Throwable e) {
            sqlInfo.setSql(String.format("SELECT COUNT(1) FROM ( %s ) TOTAL", sql));
            return sqlInfo;
        }
    }

    private static List<SelectItem> countSelectItem() {
        Function function = new Function();
        function.setName("COUNT");
        ArrayList<LongValue> expressions = new ArrayList<LongValue>();
        LongValue longValue = new LongValue(1L);
        ExpressionList expressionList = new ExpressionList();
        expressions.add(longValue);
        expressionList.setExpressions(expressions);
        function.setParameters(expressionList);
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        SelectExpressionItem selectExpressionItem = new SelectExpressionItem((Expression)function);
        selectItems.add((SelectItem)selectExpressionItem);
        return selectItems;
    }
}

