/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars;

import com.github.jknack.handlebars.PropertyPathParser;
import com.github.jknack.handlebars.ValueResolver;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;

public class Context {
    private static final Context NOOP = new Context(null){

        @Override
        public Object get(String key) {
            return null;
        }

        @Override
        protected Object get(String key, List<String> path) {
            return null;
        }
    };
    private static final String PATH_SEPARATOR = "./";
    private static final String PARENT_ATTR = "../";
    private static final String PARENT = "..";
    private static final String THIS = "this";
    private static final String MUSTACHE_THIS = ".";
    private static final Object NULL = new Object();
    private static final PropertyPathParser PATH_PARSER = new PropertyPathParser("./");
    public static final String PARTIALS = Context.class.getName() + "#partials";
    public static final String INVOCATION_STACK = Context.class.getName() + "#invocationStack";
    public static final String PARAM_SIZE = Context.class.getName() + "#paramSize";
    private Context parent;
    Object model;
    private Map<String, Object> data;
    private Context extendedContext;
    private ValueResolver resolver;

    protected Context(Object model) {
        this.model = model;
        this.extendedContext = NOOP;
        this.parent = NOOP;
    }

    private static Context root(Object model) {
        Context root = new Context(model);
        root.extendedContext = new Context(new HashMap());
        root.data = new HashMap<String, Object>();
        root.data.put(PARTIALS, new HashMap());
        root.data.put(INVOCATION_STACK, new LinkedList());
        root.data.put("root", model);
        return root;
    }

    private static Context child(Context parent, Object model) {
        Context child = new Context(model);
        child.extendedContext = new Context(new HashMap());
        child.parent = parent;
        child.data = parent.data;
        return child;
    }

    private void combine(String name, Object model) {
        Map map = (Map)this.extendedContext.model;
        map.put(name, model);
    }

    private void combine(Map<String, ?> model) {
        Map map = (Map)this.extendedContext.model;
        map.putAll(model);
    }

    public <T> T data(String name) {
        return (T)this.data.get(name);
    }

    public Context data(String name, Object value) {
        this.data.put(name, value);
        return this;
    }

    public Context data(Map<String, ?> attributes) {
        this.data.putAll(attributes);
        return this;
    }

    public Object model() {
        return this.model;
    }

    public Context parent() {
        return this.parent;
    }

    public Set<Map.Entry<String, Object>> propertySet(Object context) {
        if (context == null) {
            return Collections.emptySet();
        }
        if (context instanceof Context) {
            return this.resolver.propertySet(((Context)context).model);
        }
        return this.resolver.propertySet(context);
    }

    public Set<Map.Entry<String, Object>> propertySet() {
        return this.propertySet(this.model);
    }

    public Object get(String key) {
        if (MUSTACHE_THIS.equals(key) || THIS.equals(key)) {
            return this.internalGet(this.model);
        }
        if (key.startsWith(PARENT)) {
            if (this.parent == null) {
                return null;
            }
            return key.length() == PARENT.length() ? this.internalGet(this.parent.model) : this.parent.get(key.substring(PARENT_ATTR.length()));
        }
        return this.get(key, PATH_PARSER.parsePath(key));
    }

    protected Object get(String key, List<String> path) {
        Object value = this.internalGet(path);
        if (value == null) {
            String dataKey;
            value = this.extendedContext.get(key, path);
            if (value == null && this.data != null && (value = this.data.get(dataKey = key.charAt(0) == '@' ? key.substring(1) : key)) == null && path.size() > 1) {
                Context dataContext = Context.newBuilder(this.data).resolver(this.resolver).build();
                dataContext.data = null;
                value = dataContext.get(dataKey);
                dataContext.destroy();
            }
            if (value == null && !path.get(0).equals(THIS)) {
                value = this.parent.get(key, path);
            }
        }
        return value == NULL ? null : value;
    }

    private Object internalGet(Object candidate) {
        Object resolved = this.resolver.resolve(candidate);
        return resolved == null ? candidate : resolved;
    }

    private Object internalGet(List<String> path) {
        Object current = this.model;
        int start = path.get(0).equals(THIS) ? 1 : 0;
        int psize = path.size();
        for (int i = start; i < psize - 1; ++i) {
            if ((current = this.resolve(current, path.get(i))) != null) continue;
            return null;
        }
        String name = path.get(psize - 1);
        Object value = this.resolve(current, name);
        if (value == null && current != this.model) {
            value = NULL;
        }
        return value;
    }

    private Object resolve(Object current, String expression) {
        if (current == null) {
            return null;
        }
        Object result = this.resolver.resolve(current, expression);
        if (result != null && result != ValueResolver.UNRESOLVED) {
            return result;
        }
        if (expression.charAt(0) == '[' && expression.charAt(expression.length() - 1) == ']') {
            String idx = expression.substring(1, expression.length() - 1);
            if (NumberUtils.isDigits((String)idx) && (result = this.resolveArrayAccess(current, idx)) != NULL) {
                return result;
            }
            return this.resolver.resolve(current, idx);
        }
        if (NumberUtils.isDigits((String)expression) && (result = this.resolveArrayAccess(current, expression)) != NULL) {
            return result;
        }
        return result;
    }

    private Object resolveArrayAccess(Object current, String idx) {
        int pos = Integer.parseInt(idx);
        try {
            if (current instanceof List) {
                return ((List)current).get(pos);
            }
            if (current.getClass().isArray()) {
                return Array.get(current, pos);
            }
        }
        catch (IndexOutOfBoundsException exception) {
            return null;
        }
        return NULL;
    }

    private void setResolver(ValueResolver resolver) {
        this.resolver = resolver;
        this.extendedContext.resolver = resolver;
    }

    public void destroy() {
        this.model = null;
        if (this.parent == null && this.data != null) {
            this.data.clear();
        }
        if (this.extendedContext != null) {
            this.extendedContext.destroy();
        }
        this.parent = null;
        this.resolver = null;
        this.data = null;
    }

    public String toString() {
        return String.valueOf(this.model);
    }

    public static Builder newBuilder(Context parent, Object model) {
        return new Builder(parent, model);
    }

    public static Builder newBuilder(Object model) {
        return new Builder(model);
    }

    public static Context newContext(Context parent, Object model) {
        return Context.newBuilder(parent, model).build();
    }

    public static Context newContext(Object model) {
        return Context.newBuilder(model).build();
    }

    public static final class Builder {
        private Context context;

        private Builder(Context parent, Object model) {
            this.context = Context.child(parent, model);
        }

        private Builder(Object model) {
            this.context = Context.root(model);
        }

        public Builder combine(String name, Object model) {
            this.context.combine(name, model);
            return this;
        }

        public Builder combine(Map<String, ?> model) {
            this.context.combine(model);
            return this;
        }

        public Builder resolver(ValueResolver ... resolvers) {
            Validate.notEmpty((Object[])resolvers, (String)"At least one value-resolver must be present.", (Object[])new Object[0]);
            this.context.setResolver(new CompositeValueResolver(resolvers));
            return this;
        }

        public Context build() {
            if (this.context.resolver == null) {
                if (this.context.parent != NOOP) {
                    this.context.resolver = this.context.parent.resolver;
                } else {
                    this.context.setResolver(new CompositeValueResolver(ValueResolver.VALUE_RESOLVERS));
                }
                if (this.context.extendedContext != NOOP) {
                    this.context.extendedContext.resolver = this.context.resolver;
                }
            }
            return this.context;
        }
    }

    private static class CompositeValueResolver
    implements ValueResolver {
        private ValueResolver[] resolvers;

        public CompositeValueResolver(ValueResolver ... resolvers) {
            this.resolvers = resolvers;
        }

        @Override
        public Object resolve(Object context, String name) {
            for (ValueResolver resolver : this.resolvers) {
                Object value = resolver.resolve(context, name);
                if (value == UNRESOLVED) continue;
                return value == null ? NULL : value;
            }
            return null;
        }

        @Override
        public Object resolve(Object context) {
            for (ValueResolver resolver : this.resolvers) {
                Object value = resolver.resolve(context);
                if (value == UNRESOLVED) continue;
                return value == null ? NULL : value;
            }
            return null;
        }

        @Override
        public Set<Map.Entry<String, Object>> propertySet(Object context) {
            LinkedHashSet<Map.Entry<String, Object>> propertySet = new LinkedHashSet<Map.Entry<String, Object>>();
            for (ValueResolver resolver : this.resolvers) {
                propertySet.addAll(resolver.propertySet(context));
            }
            return propertySet;
        }
    }
}

