/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PropertyPathParser {
    private Pattern pattern;
    private ConcurrentMap<String, List<String>> cache = new ConcurrentHashMap<String, List<String>>();

    public PropertyPathParser(String pathSeparators) {
        this.pattern = Pattern.compile("((\\[[^\\[\\]]+])|([^" + Pattern.quote(pathSeparators) + "]+))");
    }

    List<String> parsePath(String key) {
        List<String> path = (List<String>)this.cache.get(key);
        if (path == null) {
            path = this.parse(key);
            this.cache.put(key, path);
        }
        return path;
    }

    private List<String> parse(String key) {
        Matcher matcher = this.pattern.matcher(key);
        LinkedList<String> tags = new LinkedList<String>();
        while (matcher.find()) {
            tags.add(matcher.group(1));
        }
        return tags;
    }
}

