/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.internal.Variable;
import java.io.IOException;

public enum ParamType {
    STRING{

        @Override
        boolean apply(Object param) {
            if (param instanceof String) {
                String string = (String)param;
                int len = string.length();
                return string.charAt(0) == '\"' && string.charAt(len - 1) == '\"' || string.charAt(0) == '\'' && string.charAt(len - 1) == '\'';
            }
            return false;
        }

        @Override
        Object doParse(Context scope, Object param) {
            String string = (String)param;
            return string.substring(1, string.length() - 1);
        }
    }
    ,
    REFERENCE{

        @Override
        boolean apply(Object param) {
            return param instanceof String;
        }

        @Override
        Object doParse(Context scope, Object param) {
            return scope.get((String)param);
        }
    }
    ,
    CONTEXT{

        @Override
        boolean apply(Object param) {
            return param instanceof Context;
        }

        @Override
        Object doParse(Context scope, Object param) {
            return ((Context)param).model();
        }
    }
    ,
    SUB_EXPRESSION{

        @Override
        boolean apply(Object param) {
            return param instanceof Variable;
        }

        @Override
        Object doParse(Context context, Object param) throws IOException {
            Variable var = (Variable)param;
            return var.apply(context);
        }
    };


    abstract boolean apply(Object var1);

    abstract Object doParse(Context var1, Object var2) throws IOException;

    public static Object parse(Context context, Object param) throws IOException {
        if (param instanceof String) {
            String str = (String)param;
            if (str.charAt(0) == '\"') {
                return str.substring(1, str.length() - 1);
            }
            if (str.charAt(0) == '\'') {
                return str.substring(1, str.length() - 1);
            }
            return context.get(str);
        }
        if (param instanceof Context) {
            return ((Context)param).model();
        }
        if (param instanceof Variable) {
            return ((Variable)param).apply(context);
        }
        return param;
    }
}

