/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.EscapingStrategy;
import com.github.jknack.handlebars.Formatter;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Lambda;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.TagType;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.internal.ForwardingTemplate;
import com.github.jknack.handlebars.internal.HelperResolver;
import com.github.jknack.handlebars.internal.Lambdas;
import com.github.jknack.handlebars.internal.ParamType;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class Variable
extends HelperResolver {
    private final String name;
    private final TagType type;
    private String startDelimiter;
    private String endDelimiter;
    private EscapingStrategy escapingStrategy;
    private final Helper<Object> helper;
    private Formatter.Chain formatter;
    private Helper<Object> missing;

    public Variable(Handlebars handlebars, String name, TagType type, List<Object> params, Map<String, Object> hash) {
        super(handlebars);
        this.name = name.trim();
        this.type = type;
        this.params(params);
        this.hash(hash);
        this.escapingStrategy = handlebars.getEscapingStrategy();
        this.helper = this.helper(name);
        this.formatter = handlebars.getFormatter();
        this.missing = handlebars.helper("helperMissing");
    }

    public Variable(Handlebars handlebars, String name, TagType type) {
        this(handlebars, name, type, Collections.EMPTY_LIST, Collections.EMPTY_MAP);
    }

    public String name() {
        return this.name;
    }

    @Override
    protected void merge(Context scope, Writer writer) throws IOException {
        Helper<Object> helper = this.helper;
        if (helper != null) {
            Options options = new Options.Builder(this.handlebars, this.name, this.type, scope, Variable.empty(this)).setParams(this.params(scope)).setHash(this.hash(scope)).setWriter(writer).build();
            options.data(Context.PARAM_SIZE, this.params.size());
            CharSequence result = helper.apply(this.determineContext(scope), options);
            writer.append(this.formatAndEscape(result, Formatter.NOOP));
        } else {
            Object value = scope.get(this.name);
            if (value == null && this.missing != null) {
                Options options = new Options.Builder(this.handlebars, this.name, this.type, scope, Variable.empty(this)).setParams(this.params(scope)).setHash(this.hash(scope)).setWriter(writer).build();
                value = this.missing.apply(this.determineContext(scope), options);
            }
            if (value instanceof Lambda) {
                value = Lambdas.merge(this.handlebars, (Lambda)value, scope, this);
            }
            writer.append(this.formatAndEscape(value, this.formatter));
        }
    }

    private static Template empty(Variable variable) {
        return new ForwardingTemplate(variable){

            @Override
            public String apply(Context context) throws IOException {
                return "";
            }

            @Override
            public void apply(Context context, Writer writer) throws IOException {
            }

            @Override
            public String apply(Object context) throws IOException {
                return "";
            }

            @Override
            public void apply(Object context, Writer writer) throws IOException {
            }
        };
    }

    @Override
    protected void collect(Collection<String> result, TagType tagType) {
        if (this.type == tagType) {
            result.add(this.name);
        }
        super.collect(result, tagType);
    }

    @Override
    protected void collectReferenceParameters(Collection<String> result) {
        for (Object param : this.params) {
            if (!ParamType.REFERENCE.apply(param) || ParamType.STRING.apply(param)) continue;
            result.add((String)param);
        }
        for (Object hashValue : this.hash.values()) {
            if (!ParamType.REFERENCE.apply(hashValue) || ParamType.STRING.apply(hashValue)) continue;
            result.add((String)hashValue);
        }
        super.collectReferenceParameters(result);
    }

    private CharSequence formatAndEscape(Object value, Formatter.Chain formatter) {
        if (value == null) {
            return "";
        }
        String formatted = formatter.format(value).toString();
        if (value instanceof Handlebars.SafeString) {
            return formatted;
        }
        if (this.type == TagType.VAR) {
            return this.escapingStrategy.escape(formatted);
        }
        return formatted;
    }

    @Override
    public String text() {
        String hash;
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.startDelimiter).append(this.name);
        String params = this.paramsToString();
        if (params.length() > 0) {
            buffer.append(" ").append(params);
        }
        if ((hash = this.hashToString()).length() > 0) {
            buffer.append(" ").append(hash);
        }
        return buffer.append(this.endDelimiter).toString();
    }

    public Variable endDelimiter(String endDelimiter) {
        this.endDelimiter = endDelimiter;
        return this;
    }

    public Variable startDelimiter(String startDelimiter) {
        this.startDelimiter = startDelimiter;
        return this;
    }

    public String startDelimiter() {
        return this.startDelimiter;
    }

    public String endDelimiter() {
        return this.endDelimiter;
    }
}

