/*
 * Decompiled with CFR 0.152.
 */
package wiremock.net.javacrumbs.jsonunit.core;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import wiremock.net.javacrumbs.jsonunit.core.ConfigurationWhen;
import wiremock.net.javacrumbs.jsonunit.core.Matchers;
import wiremock.net.javacrumbs.jsonunit.core.Option;
import wiremock.net.javacrumbs.jsonunit.core.internal.Options;
import wiremock.net.javacrumbs.jsonunit.core.internal.PathOption;
import wiremock.net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import wiremock.org.hamcrest.Matcher;

public class Configuration {
    private static final DifferenceListener DUMMY_LISTENER = (difference, context) -> {};
    private static final String DEFAULT_IGNORE_PLACEHOLDER = "${json-unit.ignore}";
    private static final String ALTERNATIVE_IGNORE_PLACEHOLDER = "#{json-unit.ignore}";
    private static final Configuration EMPTY_CONFIGURATION = new Configuration(null, Options.empty(), "${json-unit.ignore}", Matchers.empty(), Collections.emptySet(), DUMMY_LISTENER, Collections.emptyList());
    private final BigDecimal tolerance;
    private final Options options;
    private final String ignorePlaceholder;
    private final Matchers matchers;
    private final List<PathOption> pathOptions;
    private final Set<String> pathsToBeIgnored;
    private final DifferenceListener differenceListener;

    @Deprecated
    public Configuration(BigDecimal tolerance, Options options, String ignorePlaceholder) {
        this(tolerance, options, ignorePlaceholder, Matchers.empty(), Collections.emptySet(), DUMMY_LISTENER, Collections.emptyList());
    }

    private Configuration(BigDecimal tolerance, Options options, String ignorePlaceholder, Matchers matchers, Set<String> pathsToBeIgnored, DifferenceListener differenceListener, List<PathOption> pathOptions) {
        this.tolerance = tolerance;
        this.options = options;
        this.ignorePlaceholder = ignorePlaceholder;
        this.matchers = matchers;
        this.pathsToBeIgnored = pathsToBeIgnored;
        this.pathOptions = pathOptions;
        this.differenceListener = differenceListener;
    }

    public static Configuration empty() {
        return EMPTY_CONFIGURATION;
    }

    public Configuration withTolerance(BigDecimal tolerance) {
        return new Configuration(tolerance, this.options, this.ignorePlaceholder, this.matchers, this.pathsToBeIgnored, this.differenceListener, this.pathOptions);
    }

    public Configuration withTolerance(double tolerance) {
        return this.withTolerance(BigDecimal.valueOf(tolerance));
    }

    public Configuration when(Option first, Option ... next) {
        return this.withOptions(first, next);
    }

    public Configuration withOptions(Option first, Option ... next) {
        return new Configuration(this.tolerance, this.options.with(first, next), this.ignorePlaceholder, this.matchers, this.pathsToBeIgnored, this.differenceListener, this.pathOptions);
    }

    public Configuration withOptions(Options options) {
        return new Configuration(this.tolerance, options, this.ignorePlaceholder, this.matchers, this.pathsToBeIgnored, this.differenceListener, this.pathOptions);
    }

    public final Configuration when(ConfigurationWhen.PathsParam object, ConfigurationWhen.ApplicableForPath ... actions) {
        Configuration configuration = this;
        for (ConfigurationWhen.ApplicableForPath action : actions) {
            configuration = object.apply(configuration, action);
        }
        return configuration;
    }

    Configuration addPathOption(PathOption pathOption) {
        ArrayList<PathOption> newOptions = new ArrayList<PathOption>(this.pathOptions);
        newOptions.add(pathOption);
        return this.withPathOptions(newOptions);
    }

    public Configuration withPathOptions(List<PathOption> pathOptions) {
        return new Configuration(this.tolerance, this.options, this.ignorePlaceholder, this.matchers, this.pathsToBeIgnored, this.differenceListener, Collections.unmodifiableList(new ArrayList<PathOption>(pathOptions)));
    }

    public Configuration whenIgnoringPaths(Collection<String> pathsToBeIgnored) {
        return new Configuration(this.tolerance, this.options, this.ignorePlaceholder, this.matchers, Collections.unmodifiableSet(new HashSet<String>(pathsToBeIgnored)), this.differenceListener, this.pathOptions);
    }

    public Configuration whenIgnoringPaths(String ... pathsToBeIgnored) {
        return this.whenIgnoringPaths(Arrays.asList(pathsToBeIgnored));
    }

    public Configuration withIgnorePlaceholder(String ignorePlaceholder) {
        return new Configuration(this.tolerance, this.options, ignorePlaceholder, this.matchers, this.pathsToBeIgnored, this.differenceListener, this.pathOptions);
    }

    public Configuration withMatcher(String matcherName, Matcher<?> matcher) {
        return new Configuration(this.tolerance, this.options, this.ignorePlaceholder, this.matchers.with(matcherName, matcher), this.pathsToBeIgnored, this.differenceListener, this.pathOptions);
    }

    public Configuration withDifferenceListener(DifferenceListener differenceListener) {
        return new Configuration(this.tolerance, this.options, this.ignorePlaceholder, this.matchers, this.pathsToBeIgnored, differenceListener, this.pathOptions);
    }

    public static DifferenceListener dummyDifferenceListener() {
        return DUMMY_LISTENER;
    }

    public Matcher<?> getMatcher(String matcherName) {
        return this.matchers.getMatcher(matcherName);
    }

    public BigDecimal getTolerance() {
        return this.tolerance;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getIgnorePlaceholder() {
        return this.ignorePlaceholder;
    }

    public List<PathOption> getPathOptions() {
        return this.pathOptions;
    }

    public Set<String> getPathsToBeIgnored() {
        return this.pathsToBeIgnored;
    }

    public DifferenceListener getDifferenceListener() {
        return this.differenceListener;
    }

    public boolean shouldIgnore(String expectedValue) {
        if (DEFAULT_IGNORE_PLACEHOLDER.equals(this.ignorePlaceholder)) {
            return DEFAULT_IGNORE_PLACEHOLDER.equals(expectedValue) || ALTERNATIVE_IGNORE_PLACEHOLDER.equals(expectedValue);
        }
        return this.ignorePlaceholder.equals(expectedValue);
    }
}

