/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.extension.responsetemplating.RenderCache;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.JsonData;
import java.io.IOException;
import wiremock.com.github.jknack.handlebars.Options;
import wiremock.com.google.common.base.MoreObjects;
import wiremock.com.jayway.jsonpath.Configuration;
import wiremock.com.jayway.jsonpath.DocumentContext;
import wiremock.com.jayway.jsonpath.InvalidJsonException;
import wiremock.com.jayway.jsonpath.InvalidPathException;
import wiremock.com.jayway.jsonpath.JsonPath;
import wiremock.com.jayway.jsonpath.Option;
import wiremock.com.jayway.jsonpath.ParseContext;
import wiremock.com.jayway.jsonpath.Predicate;

public class HandlebarsJsonPathHelper
extends HandlebarsHelper<Object> {
    private final Configuration config = Configuration.defaultConfiguration().addOptions(Option.DEFAULT_PATH_LEAF_TO_NULL);
    private final ParseContext parseContext = JsonPath.using(this.config);

    @Override
    public Object apply(Object input, Options options) throws IOException {
        if (input == null) {
            return "";
        }
        if (options == null || options.param(0, null) == null) {
            return this.handleError("The JSONPath cannot be empty");
        }
        String jsonPathString = (String)options.param(0);
        try {
            DocumentContext jsonDocument = this.getJsonDocument(input, options);
            JsonPath jsonPath = JsonPath.compile(jsonPathString, new Predicate[0]);
            Object result = this.getValue(jsonPath, jsonDocument, options);
            return JsonData.create(result);
        }
        catch (InvalidJsonException e) {
            return this.handleError(input + " is not valid JSON", e.getJson(), e);
        }
        catch (InvalidPathException e) {
            return this.handleError(jsonPathString + " is not a valid JSONPath expression", e);
        }
    }

    private Object getValue(JsonPath jsonPath, DocumentContext jsonDocument, Options options) {
        RenderCache.Key cacheKey;
        RenderCache renderCache = HandlebarsJsonPathHelper.getRenderCache(options);
        Object value = renderCache.get(cacheKey = RenderCache.Key.keyFor(Object.class, jsonPath, jsonDocument));
        if (value == null) {
            Object defaultValue = options.hash != null ? (Object)options.hash("default") : null;
            try {
                value = jsonDocument.read(jsonPath);
            }
            catch (Exception e) {
                value = defaultValue;
            }
            if (value == null) {
                value = MoreObjects.firstNonNull(defaultValue, "");
            }
            renderCache.put(cacheKey, value);
        }
        return value;
    }

    private DocumentContext getJsonDocument(Object json, Options options) {
        RenderCache.Key cacheKey;
        RenderCache renderCache = HandlebarsJsonPathHelper.getRenderCache(options);
        DocumentContext document = (DocumentContext)renderCache.get(cacheKey = RenderCache.Key.keyFor(DocumentContext.class, json));
        if (document == null) {
            document = json instanceof String ? this.parseContext.parse((String)json) : this.parseContext.parse(json);
            renderCache.put(cacheKey, document);
        }
        return document;
    }
}

