/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import wiremock.com.github.jknack.handlebars.Context;
import wiremock.com.github.jknack.handlebars.Handlebars;
import wiremock.com.github.jknack.handlebars.TagType;
import wiremock.com.github.jknack.handlebars.Template;

public class Options {
    public final Handlebars handlebars;
    public final Context context;
    public final Template fn;
    public final Template inverse;
    public final Object[] params;
    public final Map<String, Object> hash;
    public final TagType tagType;
    public final String helperName;
    private Writer writer;
    public final List<String> blockParams;
    private boolean hasBlockParams;

    public Options(Handlebars handlebars, String helperName, TagType tagType, Context context, Template fn, Template inverse, Object[] params, Map<String, Object> hash, List<String> blockParams) {
        this.handlebars = handlebars;
        this.helperName = helperName;
        this.tagType = tagType;
        this.context = context;
        this.fn = fn;
        this.inverse = inverse;
        this.params = params;
        this.hash = hash;
        this.blockParams = blockParams;
        this.hasBlockParams = this.blockParams.size() > 0;
    }

    public Options(Handlebars handlebars, String helperName, TagType tagType, Context context, Template fn, Template inverse, Object[] params, Map<String, Object> hash, List<String> blockParams, Writer writer) {
        this.handlebars = handlebars;
        this.helperName = helperName;
        this.tagType = tagType;
        this.context = context;
        this.fn = fn;
        this.inverse = inverse;
        this.params = params;
        this.hash = hash;
        this.blockParams = blockParams;
        this.writer = writer;
        this.hasBlockParams = this.blockParams.size() > 0;
    }

    public CharSequence fn() throws IOException {
        return this.apply(this.fn, this.context, this.blockParams(this.context.model));
    }

    public CharSequence fn(Object context) throws IOException {
        Context ctx = this.wrap(context);
        return this.apply(this.fn, ctx, this.blockParams(ctx.model));
    }

    public CharSequence fn(Context context) throws IOException {
        Context ctx = this.wrap(context);
        return this.apply(this.fn, ctx, this.blockParams(ctx.model));
    }

    public CharSequence inverse() throws IOException {
        return this.apply(this.inverse, this.context, this.blockParams(this.context.model));
    }

    public CharSequence inverse(Object context) throws IOException {
        Context ctx = this.wrap(context);
        return this.apply(this.inverse, ctx, this.blockParams(ctx.model));
    }

    public CharSequence inverse(Context context) throws IOException {
        Context ctx = this.wrap(context);
        return this.apply(this.inverse, ctx, this.blockParams(ctx.model));
    }

    public CharSequence apply(Template template, Object context) throws IOException {
        Context ctx = this.wrap(context);
        return this.apply(template, ctx, this.blockParams(ctx.model));
    }

    public CharSequence apply(Template template, Context context) throws IOException {
        Context ctx = this.wrap(context);
        return this.apply(template, ctx, this.blockParams(ctx.model));
    }

    public CharSequence apply(Template template, Context context, List<Object> blockParams) throws IOException {
        Context ctx = context;
        if (this.hasBlockParams) {
            ctx = Context.newBlockParamContext(context, this.blockParams, blockParams);
        }
        return template.apply(ctx);
    }

    public CharSequence apply(Template template, Object context, List<Object> blockParams) throws IOException {
        return this.apply(template, this.wrap(context), blockParams);
    }

    public CharSequence apply(Template template) throws IOException {
        return this.apply(template, this.context, this.blockParams(this.context.model));
    }

    public <T> T param(int index) {
        return (T)this.params[index];
    }

    public <T> T param(int index, T defaultValue) {
        Object value = null;
        if (index >= 0 && index < this.params.length) {
            value = this.params[index];
        }
        return (T)(value == null ? defaultValue : value);
    }

    public <T> T get(String name, T defaultValue) {
        Object value = this.context.get(name);
        return (T)(value == null ? defaultValue : value);
    }

    public <T> T get(String name) {
        return this.get(name, null);
    }

    public Template partial(String path) {
        return this.partials().get(path);
    }

    public void partial(String path, Template partial) {
        this.partials().put(path, partial);
    }

    public <T> T hash(String name) {
        return this.hash(name, null);
    }

    public <T> T hash(String name, Object defaultValue) {
        Object value = this.hash.get(name);
        return (T)(value == null ? defaultValue : value);
    }

    public boolean isFalsy(Object value) {
        return Handlebars.Utils.isEmpty(value);
    }

    public Context wrap(Object model) {
        if (model == this.context.model || model == this.context) {
            return this.context;
        }
        if (model instanceof Context) {
            return (Context)model;
        }
        return Context.newContext(this.context, model);
    }

    private Context wrap(Context context) {
        if (context != null) {
            return context;
        }
        return Context.newContext(null);
    }

    public <T> T data(String name) {
        return this.context.data(name);
    }

    public void data(String name, Object value) {
        this.context.data(name, value);
    }

    public Set<Map.Entry<String, Object>> propertySet(Object context) {
        return this.context.propertySet(context instanceof Context ? ((Context)context).model() : context);
    }

    private Map<String, Template> partials() {
        return (Map)this.data(Context.PARTIALS);
    }

    public Buffer buffer() {
        return this.writer == null ? new InMemoryBuffer() : new NativeBuffer(this.writer);
    }

    private List<Object> blockParams(Object context) {
        if (this.blockParams.size() == 1) {
            return Arrays.asList(context);
        }
        return Collections.emptyList();
    }

    public static class Builder {
        private Handlebars handlebars;
        private Context context;
        private Template fn;
        private Template inverse = Template.EMPTY;
        private static Object[] EMPTY_PARAMS = new Object[0];
        private Object[] params = EMPTY_PARAMS;
        private Map<String, Object> hash = Collections.emptyMap();
        private TagType tagType;
        private String helperName;
        private Writer writer;
        private List<String> blockParams = Collections.emptyList();

        public Builder(Handlebars handlebars, String helperName, TagType tagType, Context context, Template fn) {
            this.handlebars = handlebars;
            this.helperName = helperName;
            this.tagType = tagType;
            this.context = context;
            this.fn = fn;
        }

        public Options build() {
            Options options = new Options(this.handlebars, this.helperName, this.tagType, this.context, this.fn, this.inverse, this.params, this.hash, this.blockParams);
            options.writer = this.writer;
            this.handlebars = null;
            this.tagType = null;
            this.context = null;
            this.fn = null;
            this.inverse = null;
            this.params = null;
            this.hash = null;
            this.writer = null;
            return options;
        }

        public Builder setHash(Map<String, Object> hash) {
            this.hash = hash;
            return this;
        }

        public Builder setBlockParams(List<String> blockParams) {
            this.blockParams = blockParams;
            return this;
        }

        public Builder setInverse(Template inverse) {
            this.inverse = inverse;
            return this;
        }

        public Builder setParams(Object[] params) {
            this.params = params;
            return this;
        }

        public Builder setWriter(Writer writer) {
            this.writer = writer;
            return this;
        }
    }

    public static class InMemoryBuffer
    implements Buffer {
        private StringBuilder buffer = new StringBuilder();

        @Override
        public Appendable append(CharSequence csq) throws IOException {
            this.buffer.append(csq);
            return this;
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) throws IOException {
            this.buffer.append(csq, start, end);
            return this;
        }

        @Override
        public Appendable append(char c) throws IOException {
            this.buffer.append(c);
            return this;
        }

        @Override
        public int length() {
            return this.buffer.length();
        }

        @Override
        public char charAt(int index) {
            return this.buffer.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.buffer.subSequence(start, end);
        }
    }

    public static class NativeBuffer
    implements Buffer {
        private Writer writer;

        public NativeBuffer(Writer writer) {
            this.writer = writer;
        }

        @Override
        public Appendable append(CharSequence csq) throws IOException {
            this.writer.append(csq);
            return this;
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) throws IOException {
            this.writer.append(csq, start, end);
            return this;
        }

        @Override
        public Appendable append(char c) throws IOException {
            this.writer.append(c);
            return this;
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public char charAt(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            return "";
        }
    }

    public static interface Buffer
    extends Appendable,
    CharSequence {
    }
}

