/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api;

import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.set.primitive.MutableByteSet;

/**
 * ByteIterable is an interface which is memory-optimized for byte primitives.
 * It is inspired by the interface RichIterable, and contains a subset of the internal iterator methods on RichIterable like collect, sum, etc.
 * The API also includes an external iterator method, which returns an ByteIterator. ByteIterator helps iterate over the ByteIterable without boxing the primitives.
 * This file was automatically generated from template file primitiveIterable.stg.
 */
public interface ByteIterable extends PrimitiveIterable
{
    ByteIterator byteIterator();

    byte[] toArray();

    boolean contains(byte value);

    boolean containsAll(byte... source);

    boolean containsAll(ByteIterable source);

    void forEach(ByteProcedure procedure);

    ByteIterable select(BytePredicate predicate);

    ByteIterable reject(BytePredicate predicate);

    <V> RichIterable<V> collect(ByteToObjectFunction<? extends V> function);

    byte detectIfNone(BytePredicate predicate, byte ifNone);

    int count(BytePredicate predicate);

    boolean anySatisfy(BytePredicate predicate);

    boolean allSatisfy(BytePredicate predicate);

    boolean noneSatisfy(BytePredicate predicate);

    MutableByteList toList();

    MutableByteSet toSet();

    MutableByteBag toBag();

    LazyByteIterable asLazy();

    <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function);


    long sum();

    byte max();

    byte maxIfEmpty(byte defaultValue);

    byte min();

    byte minIfEmpty(byte defaultValue);

    double average();

    double median();

    byte[] toSortedArray();

    MutableByteList toSortedList();
}
