/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.collection.primitive;

import java.util.Collection;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.iterator.MutableIntIterator;
import com.gs.collections.api.collection.MutableCollection;

/**
 * This file was automatically generated from template file mutablePrimitiveCollection.stg.
 *
 * @since 3.0.
 */
public interface MutableIntCollection extends IntIterable
{
    MutableIntIterator intIterator();

    boolean add(int element);

    boolean addAll(int... source);

    boolean addAll(IntIterable source);

    boolean remove(int value);

    boolean removeAll(IntIterable source);

    boolean removeAll(int... source);

    /**
     * @see Collection#retainAll(Collection)
     * @since 5.0
     */
    boolean retainAll(IntIterable elements);

    /**
     * @see Collection#retainAll(Collection)
     * @since 5.0
     */
    boolean retainAll(int... source);

    void clear();

    MutableIntCollection select(IntPredicate predicate);

    MutableIntCollection reject(IntPredicate predicate);

    <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function);

    MutableIntCollection with(int element);

    MutableIntCollection without(int element);

    MutableIntCollection withAll(IntIterable elements);

    MutableIntCollection withoutAll(IntIterable elements);

    MutableIntCollection asUnmodifiable();

    MutableIntCollection asSynchronized();

    ImmutableIntCollection toImmutable();
}
