/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.bag.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.bag.primitive.ImmutableLongBag;

/**
 * A factory which creates instances of type {@link ImmutableLongBag}.
 * This file was automatically generated from template file immutablePrimitiveBagFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableLongBagFactory
{
    /**
     * @since 6.0
     */
    ImmutableLongBag empty();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableLongBag of();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableLongBag with();

    /**
     * Same as {@link #with(long)}.
     */
    ImmutableLongBag of(long one);

    ImmutableLongBag with(long one);

    /**
     * Same as {@link #with(long[])}.
     */
    ImmutableLongBag of(long... items);

    ImmutableLongBag with(long... items);

    /**
     * Same as {@link #withAll(LongIterable)}.
     */
    ImmutableLongBag ofAll(LongIterable items);

    ImmutableLongBag withAll(LongIterable items);
}
