/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.bag.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;

/**
 * A factory which creates instances of type {@link MutableBooleanBag}.
 * This file was automatically generated from template file mutablePrimitiveBagFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableBooleanBagFactory
{
    MutableBooleanBag empty();

    /**
     * Same as {@link #empty()}.
     */
    MutableBooleanBag of();

    /**
     * Same as {@link #empty()}.
     */
    MutableBooleanBag with();

    /**
     * Same as {@link #with(boolean[])}.
     */
    MutableBooleanBag of(boolean... items);

    MutableBooleanBag with(boolean... items);

    /**
     * Same as {@link #withAll(BooleanIterable)}.
     */
    MutableBooleanBag ofAll(BooleanIterable items);

    MutableBooleanBag withAll(BooleanIterable items);
}
