/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.map.primitive;

import com.gs.collections.api.map.primitive.CharByteMap;
import com.gs.collections.api.map.primitive.ImmutableCharByteMap;

/**
 * A factory which creates instances of type {@link ImmutableCharByteMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableCharByteMapFactory
{
    /**
     * @since 6.0
     */
    ImmutableCharByteMap empty();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableCharByteMap of();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableCharByteMap with();

    /**
     * Same as {@link #with(char, byte)}.
     */
    ImmutableCharByteMap of(char key, byte value);

    ImmutableCharByteMap with(char key, byte value);

    /**
     * Same as {@link #withAll(CharByteMap)}.
     */
    ImmutableCharByteMap ofAll(CharByteMap map);

    ImmutableCharByteMap withAll(CharByteMap map);
}
