/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.map.primitive;

import com.gs.collections.api.map.primitive.ImmutableDoubleObjectMap;
import com.gs.collections.api.map.primitive.DoubleObjectMap;

/**
 * A factory which creates instances of type {@link ImmutableDoubleObjectMap}.
 * This file was automatically generated from template file immutablePrimitiveObjectMapFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableDoubleObjectMapFactory
{
    /**
     * @since 6.0
     */
    <V> ImmutableDoubleObjectMap<V> empty();

    /**
     * Same as {@link #empty()}.
     */
    <V> ImmutableDoubleObjectMap<V> of();

    /**
     * Same as {@link #empty()}.
     */
    <V> ImmutableDoubleObjectMap<V> with();

    /**
     * Same as {@link #with(double, Object)}.
     */
    <V> ImmutableDoubleObjectMap<V> of(double key, V value);

    <V> ImmutableDoubleObjectMap<V> with(double key, V value);

    /**
     * Same as {@link #withAll(DoubleObjectMap)}.
     */
    <V> ImmutableDoubleObjectMap<V> ofAll(DoubleObjectMap<? extends V> map);

    <V> ImmutableDoubleObjectMap<V> withAll(DoubleObjectMap<? extends V> map);
}
