/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.map.primitive;

import com.gs.collections.api.map.primitive.MutableCharFloatMap;
import com.gs.collections.api.map.primitive.CharFloatMap;

/**
 * A factory which creates instances of type {@link MutableCharFloatMap}.
 * This file was automatically generated from template file mutablePrimitivePrimitiveMapFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableCharFloatMapFactory
{
    MutableCharFloatMap empty();

    /**
     * Same as {@link #empty()}.
     */
    MutableCharFloatMap of();

    /**
     * Same as {@link #empty()}.
     */
    MutableCharFloatMap with();

    /**
     * Same as {@link #withAll(CharFloatMap)}.
     */
    MutableCharFloatMap ofAll(CharFloatMap map);

    MutableCharFloatMap withAll(CharFloatMap map);
}
