/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.set.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.set.primitive.MutableByteSet;

/**
 * A factory which creates instances of type {@link MutableByteSet}.
 * This file was automatically generated from template file mutablePrimitiveSetFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableByteSetFactory
{
    MutableByteSet empty();

    /**
     * Same as {@link #empty()}.
     */
    MutableByteSet of();

    /**
     * Same as {@link #empty()}.
     */
    MutableByteSet with();

    /**
     * Same as {@link #with(byte[])}.
     */
    MutableByteSet of(byte... items);

    MutableByteSet with(byte... items);

    /**
     * Same as {@link #withAll(ByteIterable)}.
     */
    MutableByteSet ofAll(ByteIterable items);

    MutableByteSet withAll(ByteIterable items);
}
