/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.stack.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.stack.primitive.ImmutableBooleanStack;

/**
 * A factory which creates instances of type {@link ImmutableBooleanStack}.
 * This file was automatically generated from template file immutablePrimitiveStackFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableBooleanStackFactory
{
    /**
     * @since 6.0
     */
    ImmutableBooleanStack empty();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableBooleanStack of();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableBooleanStack with();

    /**
     * Same as {@link #with(boolean)}.
     */
    ImmutableBooleanStack of(boolean one);

    ImmutableBooleanStack with(boolean one);

    /**
     * Same as {@link #with(boolean[])}.
     */
    ImmutableBooleanStack of(boolean... items);

    ImmutableBooleanStack with(boolean... items);

    /**
     * Same as {@link #withAll(BooleanIterable)}.
     */
    ImmutableBooleanStack ofAll(BooleanIterable items);

    ImmutableBooleanStack withAll(BooleanIterable items);

    /**
     * Same as {@link #withAllReversed(BooleanIterable)}.
     */
    ImmutableBooleanStack ofAllReversed(BooleanIterable items);

    ImmutableBooleanStack withAllReversed(BooleanIterable items);
}
