/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.stack.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.stack.primitive.ImmutableCharStack;

/**
 * A factory which creates instances of type {@link ImmutableCharStack}.
 * This file was automatically generated from template file immutablePrimitiveStackFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableCharStackFactory
{
    /**
     * @since 6.0
     */
    ImmutableCharStack empty();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableCharStack of();

    /**
     * Same as {@link #empty()}.
     */
    ImmutableCharStack with();

    /**
     * Same as {@link #with(char)}.
     */
    ImmutableCharStack of(char one);

    ImmutableCharStack with(char one);

    /**
     * Same as {@link #with(char[])}.
     */
    ImmutableCharStack of(char... items);

    ImmutableCharStack with(char... items);

    /**
     * Same as {@link #withAll(CharIterable)}.
     */
    ImmutableCharStack ofAll(CharIterable items);

    ImmutableCharStack withAll(CharIterable items);

    /**
     * Same as {@link #withAllReversed(CharIterable)}.
     */
    ImmutableCharStack ofAllReversed(CharIterable items);

    ImmutableCharStack withAllReversed(CharIterable items);
}
