/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.block.function.primitive.CharToBooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction0;
import com.gs.collections.api.block.function.primitive.BooleanToBooleanFunction;
import com.gs.collections.api.block.predicate.primitive.CharBooleanPredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableCharBooleanMap extends CharBooleanMap, MutableBooleanValuesMap
{
    void put(char key, boolean value);

    void putAll(CharBooleanMap map);

    void removeKey(char key);

    void remove(char key);

    boolean removeKeyIfAbsent(char key, boolean value);

    boolean getIfAbsentPut(char key, boolean value);

    boolean getIfAbsentPut(char key, BooleanFunction0 function);

    boolean getIfAbsentPutWithKey(char key, CharToBooleanFunction function);

    <P> boolean getIfAbsentPutWith(char key, BooleanFunction<? super P> function, P parameter);

    boolean updateValue(char key, boolean initialValueIfAbsent, BooleanToBooleanFunction function);

    MutableCharBooleanMap select(CharBooleanPredicate predicate);

    MutableCharBooleanMap reject(CharBooleanPredicate predicate);

    MutableCharBooleanMap withKeyValue(char key, boolean value);

    MutableCharBooleanMap withoutKey(char key);

    MutableCharBooleanMap withoutAllKeys(CharIterable keys);

    MutableCharBooleanMap asUnmodifiable();

    MutableCharBooleanMap asSynchronized();
}
