/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.CharFunction0;
import com.gs.collections.api.block.function.primitive.CharToCharFunction;
import com.gs.collections.api.block.predicate.primitive.CharCharPredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableCharCharMap extends CharCharMap, MutableCharValuesMap
{
    void put(char key, char value);

    void putAll(CharCharMap map);

    void removeKey(char key);

    void remove(char key);

    char removeKeyIfAbsent(char key, char value);

    char getIfAbsentPut(char key, char value);

    char getIfAbsentPut(char key, CharFunction0 function);

    char getIfAbsentPutWithKey(char key, CharToCharFunction function);

    <P> char getIfAbsentPutWith(char key, CharFunction<? super P> function, P parameter);

    char updateValue(char key, char initialValueIfAbsent, CharToCharFunction function);

    MutableCharCharMap select(CharCharPredicate predicate);

    MutableCharCharMap reject(CharCharPredicate predicate);

    MutableCharCharMap withKeyValue(char key, char value);

    MutableCharCharMap withoutKey(char key);

    MutableCharCharMap withoutAllKeys(CharIterable keys);

    MutableCharCharMap asUnmodifiable();

    MutableCharCharMap asSynchronized();


    char addToValue(char key, char toBeAdded);
}
