/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.block.function.primitive.LongToBooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction0;
import com.gs.collections.api.block.function.primitive.BooleanToBooleanFunction;
import com.gs.collections.api.block.predicate.primitive.LongBooleanPredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableLongBooleanMap extends LongBooleanMap, MutableBooleanValuesMap
{
    void put(long key, boolean value);

    void putAll(LongBooleanMap map);

    void removeKey(long key);

    void remove(long key);

    boolean removeKeyIfAbsent(long key, boolean value);

    boolean getIfAbsentPut(long key, boolean value);

    boolean getIfAbsentPut(long key, BooleanFunction0 function);

    boolean getIfAbsentPutWithKey(long key, LongToBooleanFunction function);

    <P> boolean getIfAbsentPutWith(long key, BooleanFunction<? super P> function, P parameter);

    boolean updateValue(long key, boolean initialValueIfAbsent, BooleanToBooleanFunction function);

    MutableLongBooleanMap select(LongBooleanPredicate predicate);

    MutableLongBooleanMap reject(LongBooleanPredicate predicate);

    MutableLongBooleanMap withKeyValue(long key, boolean value);

    MutableLongBooleanMap withoutKey(long key);

    MutableLongBooleanMap withoutAllKeys(LongIterable keys);

    MutableLongBooleanMap asUnmodifiable();

    MutableLongBooleanMap asSynchronized();
}
