/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction0;
import com.gs.collections.api.block.function.primitive.BooleanToBooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectBooleanPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.MutableBooleanIterator;

/**
 * This file was automatically generated from template file mutableObjectPrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableObjectBooleanMap<K> extends ObjectBooleanMap<K>
{
    MutableBooleanIterator booleanIterator();

    void clear();

    void put(K key, boolean value);

    void putAll(ObjectBooleanMap<? extends K> map);

    void removeKey(K key);

    void remove(Object key);

    boolean removeKeyIfAbsent(K key, boolean value);

    boolean getIfAbsentPut(K key, boolean value);

    boolean getIfAbsentPut(K key, BooleanFunction0 function);

    boolean getIfAbsentPutWithKey(K key, BooleanFunction<? super K> function);

    <P> boolean getIfAbsentPutWith(K key, BooleanFunction<? super P> function, P parameter);

    boolean updateValue(K key, boolean initialValueIfAbsent, BooleanToBooleanFunction function);

    MutableObjectBooleanMap<K> select(ObjectBooleanPredicate<? super K> predicate);

    MutableObjectBooleanMap<K> reject(ObjectBooleanPredicate<? super K> predicate);

    MutableBooleanCollection select(BooleanPredicate predicate);

    MutableBooleanCollection reject(BooleanPredicate predicate);

    <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function);

    MutableObjectBooleanMap<K> withKeyValue(K key, boolean value);

    MutableObjectBooleanMap<K> withoutKey(K key);

    MutableObjectBooleanMap<K> withoutAllKeys(Iterable<? extends K> keys);

    MutableObjectBooleanMap<K> asUnmodifiable();

    MutableObjectBooleanMap<K> asSynchronized();
}
