/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction0;
import com.gs.collections.api.block.function.primitive.ByteToByteFunction;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectBytePredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.iterator.MutableByteIterator;

/**
 * This file was automatically generated from template file mutableObjectPrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableObjectByteMap<K> extends ObjectByteMap<K>
{
    MutableByteIterator byteIterator();

    void clear();

    void put(K key, byte value);

    void putAll(ObjectByteMap<? extends K> map);

    void removeKey(K key);

    void remove(Object key);

    byte removeKeyIfAbsent(K key, byte value);

    byte getIfAbsentPut(K key, byte value);

    byte getIfAbsentPut(K key, ByteFunction0 function);

    byte getIfAbsentPutWithKey(K key, ByteFunction<? super K> function);

    <P> byte getIfAbsentPutWith(K key, ByteFunction<? super P> function, P parameter);

    byte updateValue(K key, byte initialValueIfAbsent, ByteToByteFunction function);

    MutableObjectByteMap<K> select(ObjectBytePredicate<? super K> predicate);

    MutableObjectByteMap<K> reject(ObjectBytePredicate<? super K> predicate);

    MutableByteCollection select(BytePredicate predicate);

    MutableByteCollection reject(BytePredicate predicate);

    <V> MutableCollection<V> collect(ByteToObjectFunction<? extends V> function);

    MutableObjectByteMap<K> withKeyValue(K key, byte value);

    MutableObjectByteMap<K> withoutKey(K key);

    MutableObjectByteMap<K> withoutAllKeys(Iterable<? extends K> keys);

    MutableObjectByteMap<K> asUnmodifiable();

    MutableObjectByteMap<K> asSynchronized();


    byte addToValue(K key, byte toBeAdded);
}
