/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.mutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.factory.list.primitive.MutableIntListFactory;
import com.gs.collections.api.list.primitive.MutableIntList;

/**
 * MutableIntListFactoryImpl is a factory implementation which creates instances of type {@link MutableIntList}.
 * This file was automatically generated from template file mutablePrimitiveListFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableIntListFactoryImpl implements MutableIntListFactory
{
    public MutableIntList empty()
    {
        return new IntArrayList();
    }

    public MutableIntList of()
    {
        return this.empty();
    }

    public MutableIntList with()
    {
        return this.empty();
    }

    public MutableIntList of(int... items)
    {
        return this.with(items);
    }

    public MutableIntList with(int... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        return IntArrayList.newListWith(items);
    }

    public MutableIntList ofAll(IntIterable items)
    {
        return this.withAll(items);
    }

    public MutableIntList withAll(IntIterable items)
    {
        return IntArrayList.newList(items);
    }
}
