/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import java.io.Serializable;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction0;
import com.gs.collections.api.block.function.primitive.ByteToByteFunction;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.ByteBytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteByteProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.iterator.MutableByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.map.primitive.ImmutableByteByteMap;
import com.gs.collections.api.map.primitive.ByteByteMap;
import com.gs.collections.api.map.primitive.MutableByteByteMap;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.tuple.primitive.ByteBytePair;
import com.gs.collections.impl.factory.primitive.ByteByteMaps;
import com.gs.collections.impl.iterator.UnmodifiableByteIterator;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableByteSet;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;

/**
 * This file was automatically generated from template file unmodifiablePrimitivePrimitiveMap.stg.
 *
 * @since 3.1.
 */
public final class UnmodifiableByteByteMap
        implements MutableByteByteMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableByteByteMap map;

    UnmodifiableByteByteMap(MutableByteByteMap map)
    {
        this.map = map;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(byte key, byte value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(ByteByteMap map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(byte key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(byte key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public byte removeKeyIfAbsent(byte key, byte value)
    {
        if (this.map.containsKey(key))
        {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public byte getIfAbsentPut(byte key, byte value)
    {
        return this.map.getIfAbsentPut(key, new ByteFunction0()
        {
            public byte value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public byte getIfAbsentPut(byte key, ByteFunction0 function)
    {
        return this.map.getIfAbsentPut(key, new ByteFunction0()
        {
            public byte value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public byte getIfAbsentPutWithKey(byte key, ByteToByteFunction function)
    {
        return this.map.getIfAbsentPut(key, new ByteFunction0()
        {
            public byte value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public <P> byte getIfAbsentPutWith(byte key, ByteFunction<? super P> function, P parameter)
    {
        return this.map.getIfAbsentPut(key, new ByteFunction0()
        {
            public byte value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public byte updateValue(byte key, byte initialValueIfAbsent, ByteToByteFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public byte get(byte key)
    {
        return this.map.get(key);
    }

    public byte getIfAbsent(byte key, byte ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public byte getOrThrow(byte key)
    {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(byte key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(byte value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(ByteProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(ByteProcedure procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(ByteByteProcedure procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public LazyByteIterable keysView()
    {
        return this.map.keysView();
    }

    public RichIterable<ByteBytePair> keyValuesView()
    {
        return this.map.keyValuesView();
    }

    public MutableByteByteMap select(ByteBytePredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableByteByteMap reject(ByteBytePredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public MutableByteIterator byteIterator()
    {
        return new UnmodifiableByteIterator(this.map.byteIterator());
    }

    public void forEach(ByteProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(BytePredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(BytePredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableByteCollection select(BytePredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableByteCollection reject(BytePredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V> MutableCollection<V> collect(ByteToObjectFunction<? extends V> function)
    {
        return this.map.collect(function);
    }

    public long sum()
    {
        return this.map.sum();
    }

    public byte max()
    {
        return this.map.max();
    }

    public byte maxIfEmpty(byte defaultValue)
    {
        return this.map.maxIfEmpty(defaultValue);
    }

    public byte min()
    {
        return this.map.min();
    }

    public byte minIfEmpty(byte defaultValue)
    {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.map.average();
    }

    public double median()
    {
        return this.map.median();
    }

    public byte addToValue(byte key, byte toBeAdded)
    {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public byte[] toSortedArray()
    {
        return this.map.toSortedArray();
    }

    public MutableByteList toSortedList()
    {
        return this.map.toSortedList();
    }

    public byte[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(byte value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(byte... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(ByteIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableByteList toList()
    {
        return this.map.toList();
    }

    public MutableByteSet toSet()
    {
        return this.map.toSet();
    }

    public MutableByteBag toBag()
    {
        return this.map.toBag();
    }

    public LazyByteIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableByteByteMap withKeyValue(byte key, byte value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableByteByteMap withoutKey(byte key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableByteByteMap withoutAllKeys(ByteIterable keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableByteByteMap asUnmodifiable()
    {
        return this;
    }

    public MutableByteByteMap asSynchronized()
    {
        return new SynchronizedByteByteMap(this);
    }

    public ImmutableByteByteMap toImmutable()
    {
        return ByteByteMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public MutableByteSet keySet()
    {
        return UnmodifiableByteSet.of(this.map.keySet());
    }

    public MutableByteCollection values()
    {
        return UnmodifiableByteCollection.of(this.map.values());
    }

    @Override
    public boolean equals(Object otherMap)
    {
        return this.map.equals(otherMap);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function)
    {
        return this.map.injectInto(injectedValue, function);
    }
}
