/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.set.primitive.ImmutableFloatSet;
import com.gs.collections.api.set.primitive.FloatSet;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import com.gs.collections.impl.set.primitive.AbstractFloatSet;

/**
 * This file was automatically generated from template file abstractImmutablePrimitiveSet.stg.
 *
 * @since 6.0.
 */
public abstract class AbstractImmutableFloatSet extends AbstractFloatSet implements ImmutableFloatSet
{
    public ImmutableFloatSet newWith(float element)
    {
        return FloatHashSet.newSet(this).with(element).toImmutable();
    }

    public ImmutableFloatSet newWithout(float element)
    {
        return FloatHashSet.newSet(this).without(element).toImmutable();
    }

    public ImmutableFloatSet newWithAll(FloatIterable elements)
    {
        return FloatHashSet.newSet(this).withAll(elements).toImmutable();
    }

    public ImmutableFloatSet newWithoutAll(FloatIterable elements)
    {
        return FloatHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    public FloatSet freeze()
    {
        return this;
    }

    public ImmutableFloatSet toImmutable()
    {
        return this;
    }
}
